

DIM HOFFSET(11)		'DIMENSION TOOL OFFSET TABLE

'LOAD PREVIOUS X,Y,Z,A COORDINATES, PORT ADDRESSES AND TOOL OFFSETS

OPEN "PARAM5.DAT" FOR INPUT AS #1
	LINE INPUT #1,A$
		X=VAL(A$)
                XNEW=X
                XOLD=X
	LINE INPUT #1,A$
		Y=VAL(A$)
                YNEW=Y
                YOLD=Y
	LINE INPUT #1,A$
		Z=VAL(A$)
                ZNEW=Z
                ZOLD=Z
	LINE INPUT #1,A$
		A=VAL(A$)
                ANEW=A
                AOLD=A
        LINE INPUT #1,A$
                B=VAL(A$)
                BNEW=B
                BOLD=B
        LINE INPUT #1,A$
                XPORT%=VAL(A$)
                YPORT%=XPORT%
        LINE INPUT #1,A$
        	ZPORT%=VAL(A$)
        LINE INPUT #1,A$
        	APORT%=VAL(A$)
'
' GET RAPID PARAMETERS
'
        LINE INPUT #1,A$
        	RAPID=VAL(A$)
        LINE INPUT #1,A$
        	ARAMP%=VAL(A$)
        LINE INPUT #1,A$
        	ACCELINC=VAL(A$)
'
' GET BACKLASH VALUES
'
	LINE INPUT #1,A$
        	BACKLASHFLAG%=VAL(A$)
        LINE INPUT #1,A$
        	XBACKVALUE=VAL(A$)
        LINE INPUT #1,A$
        	YBACKVALUE=VAL(A$)
        LINE INPUT #1,A$
        	ZBACKVALUE=VAL(A$)
        LINE INPUT #1,A$
        	ABACKVALUE=VAL(A$)
        LINE INPUT #1,A$
        	BBACKVALUE=VAL(A$)
'
' GET SAVED UNITS
'
        LINE INPUT #1,A$
        	UNIT$=A$
'
' GET STEP SIZE OF EACH AXIS
'
	LINE INPUT #1,A$
        	XSTEPSIZE=VAL(A$)
	LINE INPUT #1,A$
        	YSTEPSIZE=VAL(A$)
	LINE INPUT #1,A$
        	ZSTEPSIZE=VAL(A$)
	LINE INPUT #1,A$
        	ASTEPSIZE=VAL(A$)
	LINE INPUT #1,A$
        	BSTEPSIZE=VAL(A$)
'
' GET FILE EXTEN AND DIRECTORY
'
        LINE INPUT #1,A$
        	EXTEN$=A$
        LINE INPUT #1,A$
        	DIRNAME$=A$
'
' GET TOOL TABLE OFFSETS
'
	FOR OFFNUM = 1 TO 10
		LINE INPUT #1,A$
        	HOFFSET(OFFNUM)=VAL(A$)
	NEXT

CLOSE # 1


SCREEN 12

COLOR 15,8


' ***	SETUP SEQUENCE PATTERNS FOR HALF STEP MODE   ***'

XSEQ%=1:YSEQ%=1:ZSEQ%=1:ASEQ%=1:BSEQ%=1

XAXIS%(1)=3:XAXIS%(2)=7:XAXIS%(3)=6:XAXIS%(4)=14
XAXIS%(5)=12:XAXIS%(6)=13:XAXIS%(7)=9:XAXIS%(8)=11

YAXIS%(1)=48:YAXIS%(2)=176:YAXIS%(3)=144:YAXIS%(4)=208
YAXIS%(5)=192:YAXIS%(6)=224:YAXIS%(7)=96:YAXIS%(8)=112

ZAXIS%(1)=12:ZAXIS%(2)=8:ZAXIS%(3)=0:ZAXIS%(4)=2
ZAXIS%(5)=6:ZAXIS%(6)=7:ZAXIS%(7)=5:ZAXIS%(8)=13

AAXIS%(1)=3:AAXIS%(2)=7:AAXIS%(3)=6:AAXIS%(4)=14
AAXIS%(5)=12:AAXIS%(6)=13:AAXIS%(7)=9:AAXIS%(8)=11

REM BAXIS%(1)=48:BAXIS%(2)=176:BAXIS%(3)=144:BAXIS%(4)=208
REM BAXIS%(5)=192:BAXIS%(6)=224:BAXIS%(7)=96:BAXIS%(8)=112

BAXIS%(1)=48:BAXIS%(2)=112:BAXIS%(3)=96:BAXIS%(4)=224
BAXIS%(5)=192:BAXIS%(6)=208:BAXIS%(7)=144:BAXIS%(8)=176


XYSEQUENCE% = 51
ABSEQUENCE% = 51


XMIRROR%=1:YMIRROR%=1:ZMIRROR%=1:AMIRROR%=1:BMIRROR%=1

REM PROGRAMFLAG%=0		'SET SO NO RESET OR PROGRAM RUN CAN
				'OCCUR UNTIL A PROGRAM IS LOADED
RUNFLAG%=0		'SET SO CONTINUE DOESN'T INITIALLY CRASH

SCALE = 1
ASCALE = 1
BSCALE = 1
ZSCALE = 1 : ZDEPTHLOOP% = 1 : ZCOLOR% = 1
ZSCALEINC = 0
REPEATNUM%=1		'SET PROGRAM REPEAT FOR A SINGLE RUN
REPEATPRO%=1		'RESET PROGRAM REPEAT TO 1ST RUN

MANUALFLAG% = 0		'SET TO ACTIVATE SPACEBAR FOR FEED HOLD
PREVIEWFLAG%= -1	'SET TO -1 FOR NORMAL OUTPUT TO MOTORS
			'SET TO 1 FOR PLOT PREVIEW ONLY
SEL$ = "D"		'SET SEL/DESEL TO D INITIALLY

PLOTVIEW%=1		'SET PLOT VIEW FOR XY PLANE VIEW INITIALLY

RESETFLAG%=0		'SET SO PROGRAM WILL RUN FIRST TIME

DRYRUNFLAG% = -1	'SET TO -1 FOR NORMAL OUTPUT TO Z MOTOR
			'SET TO 1 FOR SAFE HEIGHT Z MOVEMENT
ZSAFE = 0		'SET ZSAFE HEIGHT TO 0 FOR NORMAL RUN

HOFFOLD = 0		'SET H OFFSETS TO 0 INITIALLY
HOFFNEW = 0

XJOGINC=800:YJOGINC=800:ZJOGINC=800:AJOGINC=800
XYZAINC=800
JOGIN = 0.1

XOFFSET = 0			'SET X,Y DISPLAY OFFSETS
YOFFSET = 0

PLOTSCALE = 1			'SET PLOT DISPLAY SCALE
PLOTSCALEIN = 1
PLOTZERO = 0			'SET DUMMY PLOT COLOR

GCODEMOVE = -1
GCODE = -1			'SET G AND M CODES SO M0 OR G0 ARE
MCODE = -1			'NOT INITIALLY SELECTED

PRO$ = "NONE LOADED"		'SET INITIAL PROGRAM TO NONE

SLOW = 10
MEDIUM = 400
ACCELRAMP%=400


F = 10			'SET DEFAULT F TO 10 IN/MIN
FEEDOVERIDE = 1
FEEDOVER = 100

CUTTERRADIUS = 0.1*8000

MAIN:

MENUFLAG% = 1		'SET TO 1 TO DISPLAY MENU # 1

COLOR 14
	LOCATE 1,2:PRINT" M P S 2000 V3.0a                       "
        LOCATE 2,2:PRINT"-----------------"

COLOR 15
	LOCATE 3,6:PRINT"X ="
	LOCATE 4,6:PRINT"Y ="
	LOCATE 5,6:PRINT"Z ="
	LOCATE 6,6:PRINT"A ="
        LOCATE 7,6:PRINT"B ="
	LOCATE 9,1:PRINT"SCALE ="
	LOCATE 10,1:PRINT"ZSCALE ="
        LOCATE 11,1:PRINT"PLOT SCALE ="
        LOCATE 16,1:PRINT"LOOP # ="
	LOCATE 18,1:PRINT"PROGRAM:         "
        LOCATE 12,1:PRINT"FEED ="
        LOCATE 13,1:PRINT"FEEDOVERRIDE% = "
        LOCATE 14,1:PRINT"JOG INCR ="
COLOR 11
	LOCATE 9,9:PRINT USING"#.###";SCALE
        LOCATE 10,10:PRINT USING"#.##";ZSCALE
        LOCATE 11,14:PRINT USING"#.##";PLOTSCALEIN
        LOCATE 16,9:PRINT REPEATPRO%"OF"REPEATNUM%
	LOCATE 19,1:PRINT PRO$"            "

        IF UNIT$="INCH" THEN
		LOCATE 12,7:PRINT F;"IN/MIN     "
        ELSE
        	LOCATE 12,7:PRINT F;"mm/MIN     "
        END IF

	LOCATE 13,16:PRINT FEEDOVER"    "
        LOCATE 14,12:PRINT USING"#.###";JOGIN
IF PREVIEWFLAG%= 1 THEN LOCATE 21,6:PRINT"PLOT PREVIEW"

COLOR 15

IF PLOTVIEW%=1 THEN
	LOCATE 1,46:PRINT" XY PLANE VIEW "
ELSE
	LOCATE 1,46:PRINT" 3-D PLOT VIEW "
END IF

COLOR 11

CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY:CALL ADISPLAY:CALL BDISPLAY

GOSUB MENU1

GOSUB DISPLAYWINDOW

MAIN1:

DO

DEF SEG = 0				'SEE P. 138 IBM PC & PS/2
POKE &H417,PEEK(&H417) OR 64           	'FORCE CAPS LOCK ON

REM IF MOTORFLAG%=0 THEN GOSUB DESELECTMOTORS

COLOR 15
A$ = INKEY$
SELECT CASE A$
	CASE "1"
        	MOTORFLAG%=0:MANUALFLAG%=1
                XSKIPDELAY%=0:YSKIPDELAY%=0
                ZSKIPDELAY%=0:ASKIPDELAY%=0:BSKIPDELAY%=0
                GOSUB SELECTMOTORS
                GOSUB CLEARMENU

		SPEEDTEMP=SPEED			'SAVE SPEED PARAM'
		DELAYINCTEMP&=DELAYINC&
		SPEEDINCTEMP=SPEEDINC
		ACCELRAMPTEMP%=ACCELRAMP%

                GOSUB JOGCONTINUOUS

		SPEED=SPEEDTEMP			'RESTORE SPEED PARAM'
		DELAYINC&=DELAYINCTEMP&
		SPEEDINC=SPEEDINCTEMP
		ACCELRAMP%=ACCELRAMPTEMP%

                MENUFLAG%=1:GOSUB MENU1
                MANUALFLAG%=0
	CASE "2"
        	IF SLIDEHOLD%=1 THEN EXIT SELECT
        	GOSUB LOADPROGRAM
	CASE "3"
        	IF SLIDEHOLD%=1 THEN EXIT SELECT
        	IF PROGRAMFLAG%=0 THEN EXIT SELECT
                IF RESETFLAG%=1 THEN EXIT SELECT
                RUNFLAG%=1
                REPEATPRO%=1
        	MOTORFLAG%=0:CODELINE&=0
                B$="":C$="":D$=""
                GOSUB SELECTMOTORS
                COLOR 14
                LOCATE 21,6:PRINT"START PROGRAM    "
                LOCATE 27,1:PRINT"                       "
                GOSUB CLEARMENU
                GOSUB STARTPROGRAM
                GOSUB RUNLOOP
	CASE "4"
        	COLOR 11:GOSUB ZEROAXES
		LOCATE 23,1:PRINT"                  "
		LOCATE 24,1:PRINT"                  "
	CASE "5":GOSUB XYZSCALE
	CASE "6":GOSUB ZINCDEPTH
	CASE "Q":GOTO ENDPROGRAM
        CASE "M"
        	MENUFLAG%=-MENUFLAG%
                IF MENUFLAG%=1 THEN GOSUB MENU1 ELSE GOSUB MENU2
        CASE "P":GOSUB SETPREVIEWFLAG
        CASE "L":GOSUB SETPLOTSCALE
        CASE "V"
        	PLOTVIEW% = -PLOTVIEW%
                IF PLOTVIEW%=1 THEN
                	LOCATE 1,46:PRINT" XY PLANE VIEW "
                ELSE
                	LOCATE 1,46:PRINT" 3-D PLOT VIEW "
                END IF
	CASE "C"
                IF RUNFLAG%=0 THEN EXIT SELECT
                GOSUB CLEARMENU
                COLOR 15
        	LOCATE 28,1:PRINT C$
        	COLOR 11
		LOCATE 27,1:PRINT B$
        	LOCATE 29,1:PRINT D$
		RETURN
	CASE "F":GOSUB FEEDCHANGE
	CASE "D":MOTORFLAG%=0:GOSUB DESELECTMOTORS
	CASE "S":MOTORFLAG%=1:GOSUB SELECTMOTORS
	CASE "J"
        	MANUALFLAG%=1
                XSKIPDELAY%=0:YSKIPDELAY%=0
                ZSKIPDELAY%=0:ASKIPDELAY%=0:BSKIPDELAY%=0
                GOSUB SELECTMOTORS
                GOSUB CLEARMENU
        	GOSUB JOGINCREMENT
                MENUFLAG%=1:GOSUB MENU1
                MANUALFLAG%=0
	CASE "R"
        	IF PROGRAMFLAG% = 0 THEN EXIT SELECT
        	GOSUB RESETPROGRAM
		COLOR 11
                LOCATE 26,1:PRINT"                               "
        	LOCATE 27,1:PRINT"PROGRAM RESET                  "
                LOCATE 28,1:PRINT"                               "
    		LOCATE 29,1:PRINT"                                          "
                CODELINE&=0
        CASE "7":CLS:GOTO MAIN
        CASE "O":GOSUB SETOFFSET
        CASE "Z":GOSUB DRYRUN
        CASE "T":GOSUB DISPLAYTOOLS
        CASE "B":GOSUB CHANGEPORT
        CASE "8":GOSUB MDILINE
        CASE "A":GOSUB CHANGERAPID
        CASE "U":GOSUB CHANGEUNITS
        CASE "K":GOSUB CHANGEBACKLASH
        CASE "9":GOSUB CHANGEFILEDIR
        CASE "N":GOSUB SETREPEATNUMBER
END SELECT

LOOP

XYZSCALE:
	LOCATE 23,1:PRINT"CURRENT XYZ SCALE =";SCALE
	LOCATE 24,1:INPUT"ENTER XYZ SCALE";SCALEINPUT
	LOCATE 23,1:PRINT"                             "
        LOCATE 24,1:PRINT"                             "
        IF SCALEINPUT <= 0 THEN ASCALELINE
        SCALE=SCALEINPUT
        LOCATE 23,1:PRINT"                          "
        COLOR 11
        LOCATE 9,9:PRINT USING"#.###";SCALE
        COLOR 15
        LOCATE 9,1:PRINT"SCALE ="
ASCALELINE:
        LOCATE 23,1:PRINT"CURRENT A-AXIS SCALE =";ASCALE
        LOCATE 24,1:INPUT"ENTER A-AXIS SCALE";ASCALEINPUT
        LOCATE 23,1:PRINT"                              "
        LOCATE 24,1:PRINT"                              "
        IF ASCALEINPUT <= 0 THEN BSCALELINE
        ASCALE = ASCALEINPUT
BSCALELINE:
        LOCATE 23,1:PRINT"CURRENT B-AXIS SCALE =";BSCALE
        LOCATE 24,1:INPUT"ENTER B-AXIS SCALE";BSCALEINPUT
        LOCATE 23,1:PRINT"                              "
        LOCATE 24,1:PRINT"                              "
        IF BSCALEINPUT <= 0 THEN RETURN
        BSCALE = BSCALEINPUT
RETURN

ZINCDEPTH:
	LOCATE 23,1:INPUT"ENTER DEPTH DIVISION";ZDEPTHLOOP%
	LOCATE 23,1:PRINT"                          "
        IF ZDEPTHLOOP% < 1 THEN RETURN
        ZSCALEINC=1/ZDEPTHLOOP%
        ZSCALE = ZSCALEINC
        COLOR 15
        LOCATE 10,1:PRINT"ZSCALE ="
        COLOR 11
        LOCATE 10,10:PRINT USING"#.##";ZSCALE
RETURN

SETREPEATNUMBER:
	LOCATE 23,1:INPUT"PROGRAM REPEAT NUMBER";REPEATNUMIN%
	LOCATE 23,1:PRINT"                                "
        IF REPEATNUMIN% < 1 OR REPEATNUMIN% > 10000 THEN RETURN
        REPEATNUM%=REPEATNUMIN%
        COLOR 15
        LOCATE 16,1:PRINT"LOOP # ="
        COLOR 11
        REPEATPRO%=1
        LOCATE 16,9:PRINT"                  "
        LOCATE 16,9:PRINT REPEATPRO%"OF"REPEATNUM%
RETURN

FEEDCHANGE:
	COLOR 15
	LOCATE 23,1:INPUT"ENTER FEEDOVERRIDE%";FEEDOVER
	LOCATE 23,1:PRINT"                            "
	IF FEEDOVER <= 0 THEN RETURN
	FEEDOVERIDE=FEEDOVER/100

        FEEDVALUE=FEED*FEEDOVERIDE
        FEEDRATE=66.67*FEEDVALUE
	IF FEEDVALUE > 10 THEN
		SPEED=600
		SPEEDINC = (FEEDRATE-600)/ACCELRAMP%
	ELSE
		SPEEDINC = 0
		SPEED = FEEDRATE
	END IF

        LOCATE 12,1:PRINT"                "
        LOCATE 12,1:PRINT"FEED ="
        LOCATE 13,1:PRINT"FEEDOVERRIDE% ="
        COLOR 11
	LOCATE 13,16:PRINT FEEDOVER"  "
        IF UNIT$="INCH" THEN
        	LOCATE 12,7:PRINT F*FEEDOVERIDE;"IN/MIN     "
        ELSE
                LOCATE 12,7:PRINT F*FEEDOVERIDE;"mm/MIN     "
        END IF

RETURN

DESELECTMOTORS:
	SEL$="D"
        IF MENUFLAG%<0 THEN GOSUB MENU2		'DISPLAY MENU2 TO STAY IN
	OUT XPORT%,255				'SYNCH WITH MENU SWITCHING
	OUT ZPORT%,4
	OUT APORT%,255
RETURN

SELECTMOTORS:
	IF PREVIEWFLAG%=1 THEN RETURN		'DO NOT ENERGIZE MOTORS
	SEL$ = "S"				'IF PREVIEW ONLY IS SET
        IF MENUFLAG%< 0 THEN GOSUB MENU2
	OUT XPORT%,XYSEQUENCE%
	OUT ZPORT%,ZAXIS%(ZSEQ%)
	OUT APORT%,ABSEQUENCE%
RETURN

JOGINCREMENT:
	IF UNIT$="INCH" THEN
		LOCATE 23,1:INPUT"JOG(IN.)";JOGINPUT
        ELSEIF UNIT$="mm" THEN
        	LOCATE 23,1:INPUT"JOG(mm)";JOGINPUT
        END IF
        LOCATE 23,1:PRINT"                   "
        IF JOGINPUT > 0 THEN JOGIN=JOGINPUT
        COLOR 15
        LOCATE 14,1:PRINT"JOG INCR ="
        COLOR 11
        LOCATE 14,12:PRINT USING"#.###";JOGIN
IF UNIT$="INCH" THEN
	XJOGINC=8000*JOGIN
        YJOGINC=XJOGINC:ZJOGINC=XJOGINC
        AJOGINC=XJOGINC:BJOGINC=XJOGINC
ELSEIF UNIT$="mm" THEN
        XJOGINC=314.96063*JOGIN
        YJOGINC=XJOGINC:ZJOGINC=XJOGINC
        AJOGINC=XJOGINC:BJOGINC=XJOGINC
END IF
	XYZAINC=XJOGINC
        GOSUB JOGINCMODE
RETURN

SETPREVIEWFLAG:
 	PREVIEWFLAG%= -PREVIEWFLAG%
         IF PREVIEWFLAG%= 1 THEN
REM         	XREAL=X:YREAL=Y:ZREAL=Z:AREAL=A
REM                X=XPLOTVIEW:Y=YPLOTVIEW:Z=ZPLOTVIEW:A=APLOTVIEW
         	COLOR 11
        	LOCATE 21,6:PRINT"PLOT PREVIEW"
         ELSE
REM         	XPLOTVIEW=X:YPLOTVIEW=Y:ZPLOTVIEW=Z:APLOTVIEW=A
REM                X=XREAL:Y=YREAL:Z=ZREAL:A=AREAL
REM                COLOR 11
REM                CALL XDISPLAY:CALL YDISPLAY
REM                CALL ZDISPLAY:CALL ADISPLAY
        	LOCATE 21,6:PRINT"              "
         END IF
RETURN

DRYRUN:
		IF PREVIEWFLAG%=1 THEN RETURN
        	LOCATE 23,1:INPUT"SAFE Z HEIGHT";ZSAFE
        	LOCATE 23,1:PRINT"                    "
        	IF ZSAFE < 0 THEN
                	ZSAFE=0
                        RETURN
                END IF
                ZSAFENEW = ZSAFE
                DZSAFE = ABS(ZSAFENEW-ZSAFEOLD)
                DRYRUNFLAG%=1
'
' SAVE ALL VALUES THAT WILL BE ALTERED
' THIS INCLUDES ALL COMMON PARAMETERS THAT
' ARE SHARED IN THE DELAY ROUTINE.
'
		DXYZATEMP=DXYZA
                XSKIPDELAYTEMP%=XSKIPDELAY%
                YSKIPDELAYTEMP%=YSKIPDELAY%
                ZSKIPDELAYTEMP%=ZSKIPDELAY%
                ASKIPDELAYTEMP%=ASKIPDELAY%
                BSKIPDELAYTEMP%=BSKIPDELAY%
        	ZJOGINCTEMP = ZJOGINC
                SPEEDTEMP=SPEED
                DELAYINCTEMP&=DELAYINC&
                SPEEDINCTEMP=SPEEDINC
                ACCELRAMPTEMP%=ACCELRAMP%

                ZSKIPDELAY%=0:XSKIPDELAY%=1:YSKIPDELAY%=1:ASKIPDELAY%=1
        	SPEED=RAPID
                DELAYINC&=0
                SPEEDINC=ACCELINC
                ACCELRAMP%=ARAMP%

                IF ZSAFENEW > ZSAFEOLD THEN ZINC%=1 ELSE ZINC%=-1
        	ZJOGINC = DZSAFE*ZSTEPSIZE
                ZSAFE1 = ZJOGINC		'USE FOR FAST DISPLAY PLOT
        	COLOR 11
                IF ZSAFENEW=0 THEN
                	ZSAFE1=0
                	DRYRUNFLAG%=-1
			LOCATE 21,6:PRINT"               "
                ELSE
			LOCATE 21,6:PRINT"DRY RUN        "
                END IF
                IF ZJOGINC > 0 THEN GOSUB JOGZ
'
' RESTORE ALL VALUES
'
                SPEEDINC=SPEEDINCTEMP
                ACCELRAMP%=ACCELRAMPTEMP%
                SPEED=SPEEDTEMP
                DELAYINC&=DELAYINCTEMP&
        	ZJOGINC = ZJOGINCTEMP
                XSKIPDELAY%=XSKIPDELAYTEMP%
                YSKIPDELAY%=YSKIPDELAYTEMP%
                ZSKIPDELAY%=ZSKIPDELAYTEMP%
                ASKIPDELAY%=ASKIPDELAYTEMP%
                BSKIPDELAY%=BSKIPDELAYTEMP%
                DXYZA=DXYZATEMP

                ZSAFEOLD=ZSAFENEW
                ZNEW = Z
                COLOR 11
                CALL ZDISPLAY
RETURN

'
' DISPLAY AND SET THE TOOL OFFSETS '
'

DISPLAYTOOLS:

DO
	FOR CLEARDISPLAY = 1 TO 5
        	LOCATE 17+CLEARDISPLAY,1
                PRINT"                "
        NEXT
        FOR CLEARDISPLAY = 1 TO 6
        	LOCATE 23+CLEARDISPLAY,1
                PRINT"                               "
        NEXT

	COLOR 15
		LOCATE 18,1:PRINT"H OFFSETS:"
        COLOR 11

        FOR TOOLNUMBER = 1 TO 10
		LOCATE 18+TOOLNUMBER,1
		PRINT"TOOL";TOOLNUMBER"= ";USING"#.###";HOFFSET(TOOLNUMBER)
	NEXT

        COLOR 15
        LOCATE 29,1:PRINT"                                               "
	LOCATE 29,1:INPUT"ENTER TOOL #";TOOL%
        LOCATE 29,1:PRINT"                                       "
        IF TOOL% <= 0 THEN DISPLAYTOOLSEXIT
        LOCATE 29,1:INPUT"ENTER OFFSET";HOFFSET
        LOCATE 29,1:PRINT"                                       "
        HOFFSET(TOOL%) = HOFFSET
LOOP

DISPLAYTOOLSEXIT:

	FOR TOOLNUMBER = 1 TO 12
        	LOCATE 17+TOOLNUMBER,1
                PRINT"                "
        NEXT
        LOCATE 12,1:PRINT"FEED ="
        LOCATE 13,1:PRINT"FEEDOVERRIDE% ="
        LOCATE 14,1:PRINT"JOG INCR ="
	LOCATE 18,1:PRINT"PROGRAM:         "
        COLOR 11
        LOCATE 12,7:PRINT F;"IN/MIN     "
        LOCATE 13,16:PRINT FEEDOVER
	LOCATE 14,12:PRINT USING"#.###";JOGIN
	LOCATE 19,1:PRINT PRO$"            "

RETURN

SETPLOTSCALE:

	LOCATE 23,1:INPUT"ENTER PLOT SCALE ";PLOTSCALEIN
        LOCATE 23,1:PRINT"                          "
        IF PLOTSCALEIN <= 0 THEN RETURN
        PLOTSCALE=1/PLOTSCALEIN
        GOSUB DISPLAYWINDOW
        COLOR 15
        LOCATE 11,1:PRINT"PLOT SCALE ="
        COLOR 11
        LOCATE 11,14:PRINT USING"#.##";PLOTSCALEIN

RETURN

SETOFFSET:

	LOCATE 23,1:INPUT"ENTER X CENTER LOCATION";XOFF
	LOCATE 23,1:PRINT"                                "
        LOCATE 23,1:INPUT"ENTER Y CENTER LOCATION";YOFF
        LOCATE 23,1:PRINT"                                "
	XOFFSET = -XOFF*XSTEPSIZE
        YOFFSET = -YOFF*YSTEPSIZE
        GOSUB DISPLAYWINDOW
RETURN

CHANGEPORT:
        LOCATE 23,1:PRINT"CURRENT XYZ PORT =";XPORT%
	LOCATE 24,1:INPUT"XYZ PORT(632,888,956)";PORT%
        LOCATE 23,1:PRINT"                              "
        LOCATE 24,1:PRINT"                              "
        IF PORT% > 0 THEN
        	IF PORT% <> 632 AND PORT% <> 888 AND PORT% <> 956 THEN
        		EXIT IF
        	ELSEIF PORT%=632 THEN
        		XPORT%=632:YPORT%=632:ZPORT%=634
        	ELSEIF PORT%=888 THEN
        		XPORT%=888:YPORT%=888:ZPORT%=890
        	ELSEIF PORT%=956 THEN
        		XPORT%=956:YPORT%=956:ZPORT%=958
        	END IF
        END IF
        LOCATE 23,1:PRINT"CURRENT A PORT =";APORT%
        LOCATE 24,1:INPUT"A PORT(632,888,956)";PORT2%
        LOCATE 23,1:PRINT"                              "
        LOCATE 24,1:PRINT"                              "
        IF PORT2% <> 632 AND PORT2% <> 888 AND PORT2% <> 956 THEN
        	RETURN
        ELSE
        	APORT% = PORT2%
        END IF
RETURN

MDILINE:
	CTEMP$=C$		'SAVE CURRENT C$
DO
	COLOR 14
	LOCATE 29,1:PRINT"                                            "
	LOCATE 29,1:INPUT"ENTER MDI LINE";C$
        LOCATE 29,1:PRINT"                                            "
        IF C$="" THEN EXIT LOOP
        LOCATE 29,1:PRINT C$
        XNEW=X:YNEW=Y:ZNEW=Z:ANEW=A:BNEW=B
        XOLD=X:YOLD=Y:ZOLD=Z:AOLD=A:BOLD=B
        GOSUB SELECTMOTORS
        GOSUB GETCODELINE
LOOP
	COLOR 11
        C$=CTEMP$		'RESTORE C$
        LOCATE 29,1:PRINT D$
RETURN

CHANGERAPID:
	LOCATE 23,1:PRINT"RAPID START =";RAPID
        LOCATE 24,1:INPUT"ENTER 100<RAPID<800";RAPIDINPUT
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF RAPIDINPUT <0 THEN RETURN
        IF RAPIDINPUT =>100 THEN RAPID=RAPIDINPUT
        LOCATE 23,1:PRINT"ACCEL STEPS =";ARAMP%
        LOCATE 24,1:INPUT"ENTER 100<ACCEL<1000";ACCELRAMPIN
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF ACCELRAMPIN <0 THEN RETURN
        IF ACCELRAMPIN =>100 THEN ARAMP%=ACCELRAMPIN
        LOCATE 23,1:PRINT"STEP INC =";ACCELINC
        LOCATE 24,1:INPUT"ENTER 1<STEP<10";ACCELINCIN
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF ACCELINCIN <=0 THEN RETURN
        IF ACCELINCIN >0 THEN ACCELINC=ACCELINCIN
RETURN

CHANGEUNITS:
        LOCATE 23,1:PRINT"CURRENT UNITS = ";UNIT$
	LOCATE 24,1:INPUT"(1=INCH,2=mm,3=CUSTOM)";UNITS%
        LOCATE 23,1:PRINT"                              "
        LOCATE 24,1:PRINT"                              "
        IF UNITS% <1 OR UNITS% >3 THEN RETURN

        IF UNITS% = 1 THEN
        	UNIT$="INCH"
        	LOCATE 12,1:PRINT"FEED ="
		COLOR 11
        	LOCATE 12,7:PRINT F*FEEDOVERIDE;"IN/MIN     "
		XSTEPSIZE=8000:YSTEPSIZE=8000
                ZSTEPSIZE=8000:ASTEPSIZE=80:BSTEPSIZE=80
        END IF

        IF UNITS% = 2 THEN
        	UNIT$="mm"
        	LOCATE 12,1:PRINT"FEED ="
                COLOR 11
                LOCATE 12,7:PRINT F*FEEDOVERIDE;"mm/MIN     "
		XSTEPSIZE=314.96063:YSTEPSIZE=314.96063
                ZSTEPSIZE=314.96063:ASTEPSIZE=80:BSTEPSIZE=80
        END IF

        IF UNITS% = 3 THEN
        	LOCATE 23,1:PRINT"X STEP SIZE =";XSTEPSIZE"   "
                LOCATE 24,1:INPUT"NEW X STEP SIZE";STEPSIZE
                LOCATE 24,1:PRINT"                              "
                IF STEPSIZE > 0 THEN XSTEPSIZE=STEPSIZE

                LOCATE 23,1:PRINT"Y STEP SIZE =";YSTEPSIZE"   "
                LOCATE 24,1:INPUT"NEW Y STEP SIZE";STEPSIZE
                LOCATE 24,1:PRINT"                              "
                IF STEPSIZE > 0 THEN YSTEPSIZE=STEPSIZE

                LOCATE 23,1:PRINT"Z STEP SIZE =";ZSTEPSIZE"   "
                LOCATE 24,1:INPUT"NEW Z STEP SIZE";STEPSIZE
                LOCATE 24,1:PRINT"                              "
                IF STEPSIZE > 0 THEN ZSTEPSIZE=STEPSIZE

                LOCATE 23,1:PRINT"A STEP SIZE =";ASTEPSIZE"       "
                LOCATE 24,1:INPUT"NEW A STEP SIZE";STEPSIZE
                LOCATE 24,1:PRINT"                              "
                IF STEPSIZE > 0 THEN ASTEPSIZE=STEPSIZE

                LOCATE 23,1:PRINT"B STEP SIZE =";BSTEPSIZE"       "
                LOCATE 24,1:INPUT"NEW B STEP SIZE";STEPSIZE
                LOCATE 24,1:PRINT"                              "
                IF STEPSIZE > 0 THEN BSTEPSIZE=STEPSIZE
                LOCATE 23,1:PRINT"                              "
                LOCATE 24,1:PRINT"                              "
        END IF

GOSUB DISPLAYWINDOW
COLOR 11
LOCATE 3,11:PRINT"             "
LOCATE 4,11:PRINT"             "	'CLEAR POSITION DISPLAY
LOCATE 5,11:PRINT"             "
LOCATE 6,11:PRINT"             "
LOCATE 7,11:PRINT"             "
CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY:CALL ADISPLAY:CALL BDISPLAY

RETURN

CHANGEBACKLASH:
	IF BACKLASHFLAG%=1 THEN
		LOCATE 23,1:PRINT"BACKLASH COMP = ON"
        ELSE
        	LOCATE 23,1:PRINT"BACKLASH COMP = OFF"
        END IF
        LOCATE 24,1:INPUT"1=ON,2=OFF";BACKLASHFLAG1%
        LOCATE 23,1:PRINT"                             "
        LOCATE 24,1:PRINT"                             "

	IF BACKLASHFLAG1% = 0 THEN
        	RETURN
        ELSEIF BACKLASHFLAG1% = 2 THEN
		BACKLASHFLAG%=0
        	RETURN
        ELSE
        	BACKLASHFLAG%=1
        END IF

	LOCATE 23,1:PRINT"X BACKLASH =";XBACKVALUE/XSTEPSIZE
        IF UNIT$="INCH" THEN
        	LOCATE 24,1:INPUT"X BACKLASH(INCH)";BLVALUE$
        ELSE
        	LOCATE 24,1:INPUT"X BACKLASH(mm)";BLVALUE$
        END IF
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF BLVALUE$ <> "" THEN XBACKVALUE = XSTEPSIZE*VAL(BLVALUE$)

	LOCATE 23,1:PRINT"Y BACKLASH =";YBACKVALUE/YSTEPSIZE
        IF UNIT$="INCH" THEN
        	LOCATE 24,1:INPUT"Y BACKLASH(INCH)";BLVALUE$
        ELSE
        	LOCATE 24,1:INPUT"Y BACKLASH(mm)";BLVALUE$
        END IF
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF BLVALUE$ <> "" THEN YBACKVALUE = YSTEPSIZE*VAL(BLVALUE$)

	LOCATE 23,1:PRINT"Z BACKLASH =";ZBACKVALUE/ZSTEPSIZE
        IF UNIT$="INCH" THEN
        	LOCATE 24,1:INPUT"Z BACKLASH(INCH)";BLVALUE$
        ELSE
        	LOCATE 24,1:INPUT"Z BACKLASH(mm)";BLVALUE$
        END IF
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF BLVALUE$ <> "" THEN ZBACKVALUE = ZSTEPSIZE*VAL(BLVALUE$)

	LOCATE 23,1:PRINT"A BACKLASH =";ABACKVALUE/ASTEPSIZE
        LOCATE 24,1:INPUT"A BACKLASH(DEG)";BLVALUE$
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF BLVALUE$ <> "" THEN ABACKVALUE = ASTEPSIZE*VAL(BLVALUE$)

	LOCATE 23,1:PRINT"B BACKLASH =";BBACKVALUE/BSTEPSIZE
        LOCATE 24,1:INPUT"B BACKLASH(DEG)";BLVALUE$
        LOCATE 23,1:PRINT"                           "
        LOCATE 24,1:PRINT"                           "
        IF BLVALUE$ <> "" THEN BBACKVALUE = BSTEPSIZE*VAL(BLVALUE$)
RETURN


LOADPROGRAM:
	GOSUB CLEARMENU			'CLEAR MENU
	COLOR 14
	LOCATE 23,1:PRINT"LOAD PROGRAM:"
        LOCATE 24,1:INPUT"FILE EXTENSION";EXTENSION$
SELECT CASE EXTENSION$
	CASE "COM","EXE","BAS","C"
        	LOCATE 18,1:PRINT"PROGRAM:           "
                LOCATE 19,1:PRINT PRO$"              "
        	RETURN
END SELECT
        IF EXTENSION$ <>"" THEN EXTEN$=EXTENSION$

DO
REM                DIRNAME$="C:\MPSPRO"
                SLASH$="\*."
		PROGFILE$ = DIR$(DIRNAME$+SLASH$+EXTEN$)
		IF PROGFILE$="" THEN
        		LOCATE 18,1:PRINT"PROGRAM:           "
                	LOCATE 19,1:PRINT PRO$"              "
                	RETURN
		END IF
	COLOR 14
        LOCATE 12,1:PRINT"                     "
        LOCATE 13,1:PRINT"                     "
        LOCATE 13,1:PRINT"FILE DIR = ";DIRNAME$

        LOCATE 29,1:PRINT"USE ARROW KEYS/SPACEBAR,ENTER TO SELECT"

DO WHILE PROGFILE$ <> ""
	FOR PROGCLEAR = 1 TO 15
		LOCATE 13+PROGCLEAR,1:PRINT"                     "
	NEXT PROGCLEAR
	COLOR 15
	LOCATE 14,1

PROGNUM=1

DO WHILE PROGFILE$ <> ""
	IF PROGNUM=16 THEN EXIT LOOP
        PROGRAM$(PROGNUM)=PROGFILE$
        PRINT PROGRAM$(PROGNUM)"     "
	PROGFILE$=DIR$
	PROGNUM=PROGNUM+1
LOOP

PROGLOC=0
DO
	GOSUB KEYCLEAR1
        SLEEP 1
        KEYINPUT = INP(&H60)

SELECT CASE KEYINPUT

        CASE &H01
        	GOSUB CLEARPROGSCREEN
                RETURN
	CASE &H50
        	PROGLOC=PROGLOC+1
                COLOR 15
                IF PROGLOC > 1 THEN LOCATE 13+PROGLOC-1,1:PRINT PROGRAM$(PROGLOC-1)
                IF PROGLOC=PROGNUM THEN
                	COLOR 11
                	LOCATE 14,1:PRINT PROGRAM$(1)
                        PROGLOC=1
                END IF
        	COLOR 11
		LOCATE PROGLOC+13,1:PRINT PROGRAM$(PROGLOC)
	CASE &H48
        	PROGLOC=PROGLOC-1
        	IF PROGLOC<=0 THEN
               		COLOR 15
                	LOCATE 14,1:PRINT PROGRAM$(1)
                	PROGLOC=PROGNUM-1
                END IF
        	COLOR 11
                LOCATE PROGLOC+13,1:PRINT PROGRAM$(PROGLOC)
                IF PROGLOC < PROGNUM-1 THEN
                	COLOR 15
                	LOCATE 13+PROGLOC+1,1:PRINT PROGRAM$(PROGLOC+1)
		END IF
        CASE &H1C
		IF PROGRAM$(PROGLOC)="" THEN
                	GOSUB CLEARPROGSCREEN
                        RETURN
                END IF
			PROGRAMFLAG%=1
        		PRO$ = PROGRAM$(PROGLOC)
REM			DIRECTORY$ = "C:\MPSPRO\"
			DIRECTORY$ = DIRNAME$+"\"
                	GOSUB CLEARPROGSCREEN
                        GOSUB RESETPROGRAM
                        RETURN
        CASE &H39
        	EXIT LOOP
END SELECT

LOOP

LOOP

LOOP


CLEARPROGSCREEN:

FOR PROGCLEAR = 1 TO 15
	LOCATE 13+PROGCLEAR,1:PRINT"               "
NEXT PROGCLEAR
COLOR 15
        LOCATE 12,1:PRINT"FEED ="
        LOCATE 13,1:PRINT"FEEDOVERRIDE% = "
        LOCATE 14,1:PRINT"JOG INCR ="
        LOCATE 16,1:PRINT"LOOP # ="
	LOCATE 18,1:PRINT"PROGRAM:          "
COLOR 11
	LOCATE 12,7:PRINT F;"IN/MIN     "
	LOCATE 13,16:PRINT FEEDOVER"    "
        LOCATE 14,12:PRINT USING"#.###";JOGIN
        LOCATE 16,9:PRINT REPEATPRO%"OF"REPEATNUM%
        LOCATE 19,1:PRINT PRO$"         "
	LOCATE 29,1:PRINT"                                          "

        MENUFLAG%=1:GOSUB MENU1		'RESTORE MENU1

RETURN

RESETPROGRAM:
	CLOSE # 1
	OPEN DIRECTORY$+PRO$ FOR INPUT AS #1
        ON ERROR GOTO FILERROR
        RESETFLAG%=0
        GCODE = -1
	GCODEMOVE = -1	'SET GCODEMOVE TO -1 TO CANCEL G02,G03
        		'OR OTHER GCODES IN AFFECT
        ZSCALE=1
	ZSCALEINC=0
        ZDEPTHLOOP%=1
        B$="":C$="":D$=""	'CLEAR STRINGS FOR NEXT PROGRAM

        REPEATPRO%=1
        LOCATE 16,9:PRINT REPEATPRO%"OF"REPEATNUM%

        XOLD=X:YOLD=Y:ZOLD=Z:AOLD=A		'SAVE PRESENT X,Y,Z,A
	SLIDEHOLD% = 0
RETURN

FILERROR:
	CLOSE # 1 : RESUME FILERROR1
FILERROR1:
	LOCATE 12,1:REM PRINT"        "

RETURN

CHANGEFILEDIR:
	LOCATE 23,1:PRINT"CURRENT DIR = ";DIRNAME$
        LOCATE 24,1:INPUT"NEW DIR";DIRNAMEIN$
        LOCATE 23,1:PRINT"                            "
        LOCATE 24,1:PRINT"                            "
        IF DIRNAMEIN$="" THEN RETURN
        DIRNAME$=DIRNAMEIN$
RETURN


ENDPROGRAM:

	LOCATE 23,1:INPUT"END PROGRAM(Y=YES)";ENDPRO$
	LOCATE 23,1:PRINT"                      "
        IF ENDPRO$ = "Y" THEN
        	GOSUB DESELECTMOTORS
                GOTO EXITPROGRAM
        ELSE
                GOTO MAIN1
        END IF


	' ZERO AXIS BY TYPING IT OR HIT SPACEBAR TO CANCEL '

ZEROAXES:

COLOR 15
LOCATE 23,1:PRINT"ZERO X,Y,Z,A,B ?"
LOCATE 24,1:PRINT"SPACEBAR TO CANCEL"
COLOR 11

DO
	Z$ = INKEY$
	SELECT CASE Z$
		CASE "X":X=0:XOLD=0:XNEW=0:CALL XDISPLAY:RETURN
		CASE "Y":Y=0:YOLD=0:YNEW=0:CALL YDISPLAY:RETURN
		CASE "Z":Z=0:ZOLD=0:ZNEW=0:CALL ZDISPLAY:RETURN
		CASE "A":A=0:AOLD=0:ANEW=0:CALL ADISPLAY:RETURN
                CASE "B":B=0:BOLD=0:BNEW=0:CALL BDISPLAY:RETURN
		CASE " ":RETURN
	END SELECT
LOOP

RUNLOOP:

FOR REPEATPRO% = 1 TO REPEATNUM%

FOR ZLOOP = 1 TO ZDEPTHLOOP%
		ZCOLOR% = - ZCOLOR%
	COLOR 15
		LOCATE 10,1:PRINT"ZSCALE ="
        COLOR 11
        	LOCATE 10,10:PRINT USING"#.##";ZSCALE

	LOCATE 16,9:PRINT REPEATPRO%"OF"REPEATNUM%

WHILE NOT EOF(1)      		'READ PROGRAM LINES UNTIL END IS REACHED

	B$=C$
        C$=D$
	LINE INPUT #1,D$

	CODELINE&=CODELINE&+1

        IF DRYRUNFLAG% = -1 AND PREVIEWFLAG% = -1 THEN
        	IF SINGLESTEP%=0 THEN
        		LOCATE 21,6:PRINT"RUN MODE       "
                ELSE
                	LOCATE 21,6:PRINT"SINGLE STEP    "
                END IF
        ELSEIF PREVIEWFLAG% = 1 THEN
        	LOCATE 21,6:PRINT"PLOT PREVIEW   "
        ELSEIF DRYRUNFLAG% = 1 THEN
        	LOCATE 21,6:PRINT"DRY RUN        "
        END IF

REM C$=D$

	COLOR 15
	LOCATE 26,1:PRINT"LINE";CODELINE&"        "
LOCATE 27,1:PRINT"                                                                            "
LOCATE 28,1:PRINT"                                                                            "
LOCATE 29,1:PRINT"                                                                            "
        LOCATE 28,1:PRINT C$
        COLOR 11
	LOCATE 27,1:PRINT B$
        LOCATE 29,1:PRINT D$

GOSUB GETCODELINE

IF SINGLESTEP%=1 THEN
	COLOR 14
	LOCATE 21,6:PRINT"SINGLE STEP   "
	GOSUB SINGLESTEPLINE
END IF

WEND

	CODELINE& = 0
	CLOSE # 1
	OPEN DIRECTORY$+PRO$ FOR INPUT AS #1
	SLIDEHOLD% = 0
        ZSCALE = ZSCALE + ZSCALEINC
	RESETFLAG%=1
NEXT ZLOOP

        ZSCALE=1
	ZSCALEINC=0
        ZDEPTHLOOP%=1

NEXT REPEATPRO%

	CLOSE #1
	CODELINE& = 0
        RUNFLAG%=0
        REPEATPRO%=1

	LOCATE 26,1:PRINT"                      "
        LOCATE 27,1:PRINT"                                                 "
        LOCATE 28,1:PRINT"                                                 "
     	LOCATE 29,1:PRINT"                                                 "
        LOCATE 27,1:PRINT"END OF PROGRAM"
        MENUFLAG%=1		'DISPLAY MENU1
        GOSUB MENU1

RETURN


'GET THE NEXT LINE OF G CODE'
'GCODE GROUPS ARE SPECIFIED BY HAAS STANDARD'

GETCODELINE:

FOR LETTER = 1 TO LEN(C$)

Q$ = MID$(C$, LETTER, 1)
SELECT CASE Q$

CASE "G"
	GCODE = VAL(MID$(C$,LETTER+1,10))
SELECT CASE GCODE
	CASE 0,1,2,3
		GCODEMOVE = GCODE
                GCODEMOVETEMP=GCODE		'SAVE FOR RESTORING IN
                GCODEGROUP%=1			'G90,91 AFTER G80
	CASE 17:CUTPLANE%=0:GCODEGROUP%=2
	CASE 18:CUTPLANE%=1:GCODEGROUP%=2
	CASE 19:CUTPLANE%=2:GCODEGROUP%=2
        CASE 20
GCODEGROUP%=6
UNIT$="INCH"
XSTEPSIZE=8000:YSTEPSIZE=8000:ZSTEPSIZE=8000
ASTEPSIZE=80:BSTEPSIZE=80
GOSUB DISPLAYWINDOW
COLOR 11
CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY:CALL ADISPLAY:CALL BDISPLAY

        CASE 21
GCODEGROUP%=6
UNIT$="mm"
XSTEPSIZE=314.96063:YSTEPSIZE=314.96063:ZSTEPSIZE=314.96063
ASTEPSIZE=80:BSTEPSIZE=80
GOSUB DISPLAYWINDOW
COLOR 11
CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY:CALL ADISPLAY:CALL BDISPLAY
	CASE 40:CUTTERCOMP%=0:GCODEGROUP%=7
	CASE 41:CUTTERCOMP%=1:GCODEGROUP%=7
	CASE 42:CUTTERCOMP%=2:GCODEGROUP%=7
	CASE 43:GCODEGROUP%=8
	CASE 49
        	ZOLD=ZOLD+HOFFNEW*ZSTEPSIZE
                GCODEGROUP%=8
	CASE 80
        	GCODEMOVE=-1
        	GCODEGROUP%=9
        CASE 81,83
        	GCODEMOVE=GCODE
                GCODEGROUP%=9
	CASE 90
        	INCMODE%=0
                GCODEGROUP%=3
                GCODEMOVE=GCODEMOVETEMP
	CASE 91
        	INCMODE%=1
                GCODEGROUP%=3
                GCODEMOVE=GCODEMOVETEMP
	CASE 92:GCODEGROUP%=0
	CASE 98:IPLANERETURN%=1:GCODEGROUP%=10
	CASE 99:IPLANERETURN%=0:GCODEGROUP%=10
END SELECT

CASE "X"
	XNEW = VAL(MID$(C$,LETTER+1,10))*XSTEPSIZE*SCALE*XMIRROR%
        XNEWINC=XNEW
CASE "Y"
	YNEW = VAL(MID$(C$,LETTER+1,10))*YSTEPSIZE*SCALE*YMIRROR%
        YNEWINC=YNEW
CASE "Z"
	ZNEW = (VAL(MID$(C$,LETTER+1,10))+ZSAFE)*ZSTEPSIZE*ZSCALE*SCALE*ZMIRROR%
        ZNEWINC=ZNEW
	ZDEPTH=ZNEW

CASE "A"
	ANEW = VAL(MID$(C$,LETTER+1,10))*ASTEPSIZE*ASCALE*AMIRROR%
        ANEWINC=ANEW
CASE "B"
	BNEW = VAL(MID$(C$,LETTER+1,10))*BSTEPSIZE*BSCALE*BMIRROR%
        BNEWINC=BNEW
CASE "I"
	IINC = VAL(MID$(C$,LETTER+1,10))*XSTEPSIZE*SCALE
CASE "J"
	JINC = VAL(MID$(C$,LETTER+1,10))*YSTEPSIZE*SCALE
CASE "R"
	RPLANE = VAL(MID$(C$,LETTER+1,10))*ZSTEPSIZE*SCALE
CASE "Q"
	QPECKINC = VAL(MID$(C$,LETTER+1,10))*ZSTEPSIZE*SCALE
CASE "F"
	F = VAL(MID$(C$,LETTER+1,10))
CASE "H"
	HNEW = VAL(MID$(C$,LETTER+1,10))
CASE "M"
	MCODE = VAL(MID$(C$,LETTER+1,10))
CASE "(" : EXIT FOR
CASE "'" : EXIT FOR				'EXIT ENTIRE LINE IF
CASE ";" : EXIT FOR				'IDENTIFIED AS A COMMENT

END SELECT


'SPEEDINC = ACCEL. VARIABLE IN DELAY ROUTINES'
'SET TO 0 FOR CIRCLULAR MOVES SO NO ACCEL. OCCURS'

SELECT CASE GCODEMOVE

CASE 0
	SPEED=RAPID:SPEEDINC=ACCELINC:DELAYINC&=0
        ACCELRAMP%=ARAMP%
	LOCATE 12,1:PRINT"RAPID MOVE               "

CASE 1,2,3,81,83
	DELAYINC&=0:ACCELRAMP%=ARAMP%

        COLOR 15
        	LOCATE 12,1:PRINT"FEED ="
        COLOR 11

        	IF UNIT$="INCH" THEN
			LOCATE 12,7:PRINT F*FEEDOVERIDE;"IN/MIN     "
                        FEED = F*FEEDOVERIDE
                ELSE
                	LOCATE 12,7:PRINT F*FEEDOVERIDE;"mm/MIN     "
                        FEED = (F/25.4)*FEEDOVERIDE
                END IF

	IF FEED = 0 THEN FEED = 1
        IF FEED > 60 THEN FEED = 60
	FEEDRATE = 66.67*FEED
	IF FEED > 10 THEN

		SPEED=RAPID
		SPEEDINC = (FEEDRATE-SPEED)/ACCELRAMP%
	ELSE
		SPEEDINC = 0
		SPEED = FEEDRATE
	END IF

END SELECT

NEXT LETTER


IF GCODE = 92 THEN
	GCODEMOVE = -1
        XOLD=XNEW:YOLD=YNEW:ZOLD=ZNEW:AOLD=ANEW:BOLD=BNEW
        X=XNEW:Y=YNEW:Z=ZNEW:A=ANEW:B=BNEW
        XNEWINC=0:YNEWINC=0:ZNEWINC=0:ANEWINC=0:BNEWINC=0
        COLOR 11
        CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY
        CALL ADISPLAY:CALL BDISPLAY
END IF


'ADD TOOL HEIGHT OFFSET VALUE
'USE ABSOLUTE VALUE OF TOOL LENGTH

IF GCODE = 43 THEN
	HOFFOLD = HOFFNEW
        HOFFNEW = HOFFSET(HNEW)
        ZOLD=ZOLD-HOFFNEW*ZSTEPSIZE
END IF

SELECT CASE GCODEMOVE

	CASE 0:GOSUB XYZAMOVE
	CASE 1:GOSUB XYZAMOVE
	CASE 2
        	XSKIPDELAY%=0:YSKIPDELAY%=0:ZSKIPDELAY%=0
        	XEND=XNEW:YEND=YNEW:SPEEDINC=0
                CALL CIRCULARINTCW
	CASE 3
        	XSKIPDELAY%=0:YSKIPDELAY%=0:ZSKIPDELAY%=0
        	XEND=XNEW:YEND=YNEW:SPEEDINC=0
                CALL CIRCULARINTCCW
	CASE 81:PECKDRILL%=0:CALL DRILLCYCLE
	CASE 83:PECKDRILL%=1:CALL DRILLCYCLE

END SELECT

SELECT CASE MCODE

	CASE 0:GOSUB PROGRAMSTOP
        CASE 1
        CASE 2
        CASE 3
        CASE 6:GOSUB MANUALTOOLCHANGE
        CASE 8
        CASE 9
        CASE 21
        CASE 22
        CASE 23
        CASE 30
        CASE 98
        CASE 99

END SELECT

RETURN


	' MANUAL JOG INCREMENT MODE '

JOGINCMODE:
PREVIEWFLAGTEMP%=PREVIEWFLAG%
PREVIEWFLAG%=-1				'SET FLAG FOR OUTPUT TO MOTORS
LOCATE 23,1:PRINT"JOG INC MODE         "
LOCATE 24,1:PRINT"Q = QUIT             "
LOCATE 14,1:PRINT"JOG INCR ="
LOCATE 14,12:PRINT USING"#.###";JOGIN
SPEEDINC=ACCELINC
ACCELRAMP%=ARAMP%
DELAYINC&=0
SPEED=RAPID

COLOR 11

KEYSCANLOOP:
	SPEED=RAPID
	DELAYINC&=0
	SLEEP 1			'DELAY TO AVOID RAPID KEY REPEAT
	ASM CLI
	ASM IN AL,&H60
	ASM CMP AL,77		;IS IT R.ARROW KEY
	ASM JNZ NOTPOSX
        XINC% = 1
	GOSUB JOGX
NOTPOSX:
	ASM CMP AL,75		;IS IT L.ARROW KEY
	ASM JNZ NOTNEGX
        XINC% = -1
	GOSUB JOGX
NOTNEGX:
	ASM CMP AL,72
        ASM JNZ NOTPOSY		;IS IT UP ARROW KEY
        YINC% = 1
        GOSUB JOGY
NOTPOSY:
	ASM CMP AL,80
        ASM JNZ NOTNEGY		;IS IT DOWN ARROW KEY
        YINC% = -1
        GOSUB JOGY
NOTNEGY:
	ASM CMP AL,73
        ASM JNZ NOTPOSZ		;IS IT PAGE UP KEY
        ZINC% = 1
        GOSUB JOGZ
NOTPOSZ:
	ASM CMP AL,81
        ASM JNZ NOTNEGZ		;IS IT PAGE DOWN KEY
        ZINC% = -1
        GOSUB JOGZ
NOTNEGZ:
	ASM CMP AL,78
        ASM JNZ NOTPOSA		;IS IT + KEY
        AINC% = 1
        GOSUB JOGA
NOTPOSA:
	ASM CMP AL,74		;IS IT - KEY
        ASM JNZ NOTNEGA
        AINC% = -1
        GOSUB JOGA
NOTNEGA:
	ASM CMP AL,71
        ASM JNZ NOTPOSB		;IS IT 'HOME' KEY
        BINC% = 1
        GOSUB JOGB
NOTPOSB:
	ASM CMP AL,79		;IS IT 'END' KEY
        ASM JNZ NOTNEGB
        BINC% = -1
        GOSUB JOGB
NOTNEGB:
	ASM CMP AL,16		;CHECK FOR Q KEY TO QUIT
	ASM JZ NOTKEYSCANLOOP
        GOSUB KEYCLEAR1
        ASM JMP KEYSCANLOOP
NOTKEYSCANLOOP:
	ASM STI
        GOSUB EXITJOGMODE
	RETURN

JOGX:
	FOR DELX = 1 TO XJOGINC
	DXYZA = XJOGINC
	CALL STEPX
	NEXT
	X = X + XINC%*(DELX-1)  	'DELX-1 SINCE NEXT LOOP IS
        CALL XDISPLAY			'EXECUTED N+1 TIMES
	XOLD = X : DELX = 0
RETURN

JOGY:
	FOR DELY = 1 TO YJOGINC
	DXYZA = YJOGINC
	CALL STEPY
	NEXT
	Y = Y + YINC%*(DELY-1)
	CALL YDISPLAY
	YOLD = Y : DELY = 0
RETURN

JOGZ:
	FOR DELZ = 1 TO ZJOGINC
	DXYZA = ZJOGINC
	CALL STEPZ
	NEXT
	Z = Z + ZINC%*(DELZ-1)
	CALL ZDISPLAY
	ZOLD = Z : DELZ = 0
RETURN

JOGA:
	FOR DELA = 1 TO AJOGINC
	DXYZA = AJOGINC
	CALL STEPA
	NEXT
	A = A + AINC%*(DELA-1)
	CALL ADISPLAY
	AOLD = A : DELA = 0
RETURN

JOGB:
	FOR DELB = 1 TO BJOGINC
	DXYZA = BJOGINC
	CALL STEPB
	NEXT
	B = B + BINC%*(DELB-1)
	CALL BDISPLAY
	BOLD = B : DELB = 0
RETURN


	'        *** CONTINUOUS JOG MODE ***        '
	' SET FAST JOG FIRST '
	' SET BH = 0 SO FAST JOG DISPLAY IS NOT UPDATED '
        ' SET PREVIEWFLAG%=-1 FOR OUTPUT TO MOTORS '

JOGCONTINUOUS:

DEF SEG = 0				'SEE P. 138 IBM PC & PS/2
TEMP417 = PEEK(&H417)                   'SAVE KEYBOARD STATUS BYTE
POKE &H417,PEEK(&H417) AND 223		'TURN OFF NUM LOCK SINCE IT
 					'ALLOWS JOG KEYS TO INTERFERE

TEMPNUMLOCK417 = PEEK(&H417)		'SAVE ALTERED STATUS BYTE

PREVIEWFLAGTEMP%=PREVIEWFLAG%
PREVIEWFLAG%=-1
SPEED=RAPID
ACCELRAMP%=ARAMP%
SPEEDINC=ACCELINC
DELAYINC&=0
DXYZA=0

COLOR 15

LOCATE 18,1:PRINT"                 "
LOCATE 19,1:PRINT"JOG CONTINUOUS   "
LOCATE 20,1:PRINT"SELECT X,Y,Z,A,B     "
LOCATE 21,1:PRINT"S = SLOW JOG     "
LOCATE 22,1:PRINT"M = MEDIUM JOG   "
LOCATE 23,1:PRINT"F = FAST JOG     "
LOCATE 24,1:PRINT"RIGHT SHIFT +    "
LOCATE 25,1:PRINT"LEFT SHIFT -     "
LOCATE 26,1:PRINT"Q = QUIT                       "
LOCATE 28,1:PRINT"                                                    "
LOCATE 29,1:PRINT"                                                    "
COLOR 11
LOCATE 27,1:PRINT"JOG SPEED = FAST                                    "

	ASM CLI
        ASM MOV BH,0		;INITIALIZE BH SO RAPID JOG POSITION
        			'IS NOT DISPLAYED SIMULTANEOUSLY
JOGKEYLOOP:
REM	ASM CLI
	ASM IN AL,&H60		; GET KEY SCAN CODE FROM KEYBOARD
        ASM CMP AL,170		; KEY SCAN CODE WHEN L.SHIFT RELEASED
        ASM JZ NEWDISPLAY
	ASM CMP AL,182		; KEY SCAN CODE WHEN R.SHIFT RELEASED
        ASM JZ NEWDISPLAY
        ASM JMP NONEWDISPLAY

NEWDISPLAY:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        ASM CMP BL,45		;DEACCELERATE X AXIS ONLY
        ASM JNZ NOTXDEACCEL
        ASM JMP XDEACCEL	;UPDATE DISPLAY ONLY AFTER SHIFT RELEASED
NOTXDEACCEL:
	ASM CMP BL,21		;DEACCELERATE Y AXIS ONLY
        ASM JNZ NOTYDEACCEL
        ASM JMP YDEACCEL
NOTYDEACCEL:
	ASM CMP BL,44		;DEACCELERATE Z AXIS ONLY
        ASM JNZ NOTZDEACCEL
        ASM JMP ZDEACCEL
NOTZDEACCEL:
	ASM CMP BL,30		;DEACCELERATE A AXIS ONLY
        ASM JNZ NOTADEACCEL
        ASM JMP ADEACCEL
NOTADEACCEL:
	ASM CMP BL,48		;DEACCELERATE B AXIS ONLY
        ASM JNZ NOTBDEACCEL
        ASM JMP BDEACCEL
NOTBDEACCEL:
	ASM JMP XYZADISPLAY

XDEACCEL:
	IF XDFLAG%=0 THEN XYZADISPLAY
        IF SPEED=MEDIUM OR SPEED=SLOW THEN XYZADISPLAY	'SKIP DEACCEL IF NOT RAPID
	FOR DELX& = 1 TO ACCELRAMP%
        	CALL STEPX			'DEACCEL X MOTOR FROM RAPID
	NEXT
	X = X + XINC%*DELX&
	XOLD = X : DELX& = 0
        XDFLAG%=0
        SPEED=RAPID
        GOTO XYZADISPLAY

YDEACCEL:
	IF YDFLAG%=0 THEN XYZADISPLAY
        IF SPEED=MEDIUM OR SPEED=SLOW THEN XYZADISPLAY	'SKIP DEACCEL IF NOT RAPID
	FOR DELY& = 1 TO ACCELRAMP%
        	CALL STEPY			'DEACCEL Y MOTOR FROM RAPID
	NEXT
	Y = Y + YINC%*DELY&
	YOLD=Y:DELY&=0
        YDFLAG%=0
        SPEED=RAPID
        GOTO XYZADISPLAY

ZDEACCEL:
	IF ZDFLAG%=0 THEN XYZADISPLAY
        IF SPEED=MEDIUM OR SPEED=SLOW THEN XYZADISPLAY	'SKIP DEACCEL IF NOT RAPID
	FOR DELZ& = 1 TO ACCELRAMP%
        	CALL STEPZ			'DEACCEL Z MOTOR FROM RAPID
	NEXT
	Z = Z + ZINC%*DELZ&
	ZOLD=Z:DELZ&=0
        ZDFLAG%=0
        SPEED=RAPID
        GOTO XYZADISPLAY

ADEACCEL:
	IF ADFLAG%=0 THEN XYZADISPLAY
        IF SPEED=MEDIUM OR SPEED=SLOW THEN XYZADISPLAY	'SKIP DEACCEL IF NOT RAPID
	FOR DELA& = 1 TO ACCELRAMP%
        	CALL STEPA			'DEACCEL A MOTOR FROM RAPID
	NEXT
	A = A + AINC%*DELA&
	AOLD=A:DELA&=0
        ADFLAG%=0
        SPEED=RAPID
        GOTO XYZADISPLAY

BDEACCEL:
	IF BDFLAG%=0 THEN XYZADISPLAY
        IF SPEED=MEDIUM OR SPEED=SLOW THEN XYZADISPLAY	'SKIP DEACCEL IF NOT RAPID
	FOR DELB& = 1 TO ACCELRAMP%
        	CALL STEPB			'DEACCEL B MOTOR FROM RAPID
	NEXT
	B = B + BINC%*DELB&
	BOLD=B:DELB&=0
        BDFLAG%=0
        SPEED=RAPID

XYZADISPLAY:
		CALL XDISPLAY
	        CALL YDISPLAY
	        CALL ZDISPLAY
	        CALL ADISPLAY
                CALL BDISPLAY
                XOLD=X:YOLD=Y:ZOLD=Z:AOLD=A:BOLD=B
                DELAYINC&=0			'SET BACK TO 0 SO NEXT
                  				'JOG WILL ACCELERATE
DEF SEG = 0
POKE &H417,TEMPNUMLOCK417 OR 2	'RESTORE ALTERED KEYBOARD STATUS BYTE
GOSUB KEYCLEAR1

        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS

NONEWDISPLAY:
	ASM CMP AL,45		; IS IT X KEY
        ASM JNZ NOTXKEY
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        LOCATE 28,1:PRINT"AXIS = X"
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM MOV BL,AL
NOTXKEY:
	ASM CMP AL,21		;IS IT Y KEY
        ASM JNZ NOTYKEY
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        LOCATE 28,1:PRINT"AXIS = Y"
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM MOV BL,AL
NOTYKEY:
	ASM CMP AL,44
        ASM JNZ NOTZKEY		;IS IT Z KEY
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        LOCATE 28,1:PRINT"AXIS = Z"
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM MOV BL,AL
NOTZKEY:
	ASM CMP AL,30
        ASM JNZ NOTAKEY		;IS IT A KEY
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        LOCATE 28,1:PRINT"AXIS = A"
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM MOV BL,AL
NOTAKEY:
	ASM CMP AL,48
        ASM JNZ NOTBKEY		;IS IT B KEY
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        LOCATE 28,1:PRINT"AXIS = B"
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM MOV BL,AL
NOTBKEY:
	ASM CMP AL,33			; F KEY THEN SET FAST JOG
        ASM JNZ NOTFKEY
        ASM MOV BH,0			;STORE FAST JOG CODE
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        SPEED=RAPID
        LOCATE 27,1:PRINT"JOG SPEED = FAST  "
        SPEEDINC=ACCELINC
        DXYZA=0:DELAYINC&=0
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
       	ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTFKEY:
	ASM CMP AL,50			; M KEY THEN SET MEDIUM JOG
        ASM JZ MKEY
        ASM JMP NOTMKEY
MKEY:
        ASM MOV BH,1			;SET CONTINUOUS DISPLAY UPDATE FLAG
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        SPEED=MEDIUM
        LOCATE 27,1:PRINT"JOG SPEED = MED   "
        SPEEDINC=0
        DXYZA=0:DELAYINC&=0
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTMKEY:
	ASM CMP AL,31			; S KEY THEN SET SLOW JOG
        ASM JZ SKEY
        ASM JMP NOTSKEY
SKEY:
        ASM MOV BH,1			; STORE SLOW JOG CODE
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        SPEED=SLOW
        LOCATE 27,1:PRINT"JOG SPEED = SLOW  "
	SPEEDINC=0
        DXYZA=0:DELAYINC&=0
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTSKEY:
	ASM CMP AL,16		;Q KEY THEN QUIT
	ASM JZ QUITKEY
	ASM JMP NOTQKEY
QUITKEY:
	ASM STI			;RESTORE INTERRUPTS
        GOSUB EXITJOGMODE	'CLEAR DISPLAY AND KEYBOARD BUFFER
	DEF SEG = 0
	POKE &H417,TEMP417	'RESTORE KEYBOARD STATUS BYTE
	RETURN			'BACK TO MAIN

NOTQKEY:
	ASM CMP AL,54    	;IS IT R.SHIFT KEY
        ASM JNZ NOTRSHIFT
REM        ASM MOV AH,AL
        ASM JMP RSHIFT
NOTRSHIFT:
	ASM CMP AL,42		;IS IT L.SHIFT KEY
        ASM JNZ NOTLSHIFT
REM        ASM MOV AH,AL
        ASM JMP LSHIFT
NOTLSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        GOSUB KEYCLEAR1			'CLEAR KEYBOARD BUFFER SO KEYS
	ASM POPF
	ASM POP SI			;ARE NOT STORED FOR NEXT SCAN
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
	ASM JMP JOGKEYLOOP

RSHIFT:
REM	ASM CLI
	ASM IN AL,&H60		; GET KEY SCAN CODE FROM KEYBOARD
        ASM CMP AL,182		; KEY SCAN CODE WHEN R.SHIFT RELEASED
        ASM JNZ RSHIFTSCAN
	ASM JMP JOGKEYLOOP
RSHIFTSCAN:
	ASM CMP BL,45
     	ASM JNZ NOTXRSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        XINC% = 1
        X = X + XINC%
        XDFLAG%=1				'SET DEACCELERATION FLAG SO
        DXYZA = DELAYINC& + ACCELRAMP%+1	'IT CAN DEACCELEATE WHEN
        CALL STEPX				'SHIFT KEY IS RELEASED
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ XRSHIFT
        ASM JMP RSHIFT
XRSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL XDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM JMP RSHIFT
NOTXRSHIFT:
 	ASM CMP BL,21
        ASM JNZ NOTYRSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        YINC% = 1
        Y = Y + YINC%
        YDFLAG%=1
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ YRSHIFT
        ASM JMP RSHIFT
YRSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL YDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM JMP RSHIFT
NOTYRSHIFT:
	ASM CMP BL,44
        ASM JNZ NOTZRSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        ZINC% = 1
        Z = Z + ZINC%
        ZDFLAG%=1				'SET DEACCELERATION FLAG SO
        DXYZA = DELAYINC& + ACCELRAMP%+1	'IT CAN DEACCELEATE WHEN
        CALL STEPZ				'SHIFT KEY IS RELEASED
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ ZRSHIFT
        ASM JMP RSHIFT
ZRSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL ZDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
	ASM JMP RSHIFT
NOTZRSHIFT:
	ASM CMP BL,30
        ASM JNZ NOTARSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        AINC% = 1
        A = A + AINC%
        ADFLAG%=1				'SET DEACCELERATION FLAG SO
        DXYZA = DELAYINC& + ACCELRAMP%+1	'IT CAN DEACCELEATE WHEN
        CALL STEPA				'SHIFT KEY IS RELEASED
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ ARSHIFT
        ASM JMP RSHIFT
ARSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL ADISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTARSHIFT:
	ASM CMP BL,48
        ASM JNZ NOTBRSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        BINC% = 1
        B = B + BINC%
        BDFLAG%=1				'SET DEACCELERATION FLAG SO
        DXYZA = DELAYINC& + ACCELRAMP%+1	'IT CAN DEACCELEATE WHEN
        CALL STEPB				'SHIFT KEY IS RELEASED
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ BRSHIFT
        ASM JMP RSHIFT
BRSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL BDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTBRSHIFT:
	ASM JMP RSHIFT

LSHIFT:
REM 	ASM CLI
	ASM IN AL,&H60		; GET KEY SCAN CODE FROM KEYBOARD
        ASM CMP AL,170		; KEY SCAN CODE WHEN L.SHIFT RELEASED
        ASM JNZ LSHIFTSCAN
	ASM JMP JOGKEYLOOP
LSHIFTSCAN:
	ASM CMP BL,45
        ASM JNZ NOTXLSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        XINC% = -1
        X = X + XINC%
        XDFLAG%=1			'SET DEACELERATION FLAG
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPX
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ XLSHIFT
        ASM JMP LSHIFT
XLSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL XDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
	ASM JMP LSHIFT
NOTXLSHIFT:
	ASM CMP BL,21
        ASM JNZ NOTYLSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        YINC% = -1
        Y = Y + YINC%
        YDFLAG%=1
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ YLSHIFT
        ASM JMP LSHIFT
YLSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL YDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
	ASM JMP LSHIFT
NOTYLSHIFT:
	ASM CMP BL,44
        ASM JNZ NOTZLSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        ZINC% = -1
        Z = Z + ZINC%
        ZDFLAG%=1			'SET DEACCELERATION FLAG
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPZ
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ ZLSHIFT
        ASM JMP LSHIFT
ZLSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL ZDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
	ASM JMP LSHIFT
NOTZLSHIFT:
	ASM CMP BL,30
        ASM JNZ NOTALSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        AINC% = -1
        A = A + AINC%
        ADFLAG%=1			'SET DEACCELERATION FLAG
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPA
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ ALSHIFT
        ASM JMP LSHIFT
ALSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL ADISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTALSHIFT:
	ASM CMP BL,48
        ASM JNZ NOTBLSHIFT
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        BINC% = -1
        B = B + BINC%
        BDFLAG%=1			'SET DEACCELERATION FLAG
        DXYZA = DELAYINC& + ACCELRAMP%+1
        CALL STEPB
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
        ASM CMP BH,1
        ASM JZ BLSHIFT
        ASM JMP LSHIFT
BLSHIFT:
	ASM PUSH DS
        ASM PUSH ES
	ASM PUSH AX
	ASM PUSH BX
        ASM PUSH CX
        ASM PUSH DX
        ASM PUSH DI
        ASM PUSH SI
        ASM PUSHF
        CALL BDISPLAY
        ASM POPF
	ASM POP SI
        ASM POP DI
        ASM POP DX
	ASM POP CX
        ASM POP BX
        ASM POP AX
        ASM POP ES
        ASM POP DS
NOTBLSHIFT:
	ASM JMP LSHIFT

EXITJOGMODE:
        LOCATE 19,1:PRINT"                          "
	LOCATE 20,1:PRINT"                          "
	LOCATE 21,1:PRINT"                          "
	LOCATE 22,1:PRINT"                          "
	LOCATE 23,1:PRINT"                          "
        LOCATE 24,1:PRINT"                          "
	LOCATE 25,1:PRINT"                          "
	LOCATE 26,1:PRINT"                          "
	LOCATE 27,1:PRINT"                          "
	LOCATE 28,1:PRINT"                          "
        LOCATE 29,1:PRINT"                                                 "

        COLOR 15
	        LOCATE 12,1:PRINT"FEED ="
	        LOCATE 13,1:PRINT"FEEDOVERRIDE% ="
        	LOCATE 14,1:PRINT"JOG INCR ="
		LOCATE 18,1:PRINT"PROGRAM:         "

        COLOR 11

        IF UNIT$="INCH" THEN
        	LOCATE 12,7:PRINT F*FEEDOVERIDE;"IN/MIN     "
        ELSE
                LOCATE 12,7:PRINT F*FEEDOVERIDE;"mm/MIN     "
        END IF

		LOCATE 13,16:PRINT FEEDOVER
        	LOCATE 14,12:PRINT USING"#.###";JOGIN
		LOCATE 19,1:PRINT PRO$"            "
                COLOR 15
        IF RUNFLAG%=1 THEN
		LOCATE 26,1:PRINT"LINE";CODELINE&"        "
        END IF
        	LOCATE 28,1:PRINT C$
        	COLOR 11
		LOCATE 27,1:PRINT B$
        	LOCATE 29,1:PRINT D$
		LOCATE 27,30:PRINT"     "		'CLEAR SPACE FOR MENU1
		LOCATE 28,30:PRINT"     "

	GOSUB DISPLAYWINDOW

PREVIEWFLAG%=PREVIEWFLAGTEMP%	'RESTORE PREVIEWFLAG

REM XOLD=X:YOLD=Y:ZOLD=Z:AOLD=A
REM XNEW=X:YNEW=Y:ZNEW=Z:ANEW=A

' *************************************
' *** CLEAR KEYBOARD BUFFER ROUTINE ***
' *************************************

KEYCLEAR1:
	ASM MOV AH,1		;CLEAR KEYBOARD BUFFER
        ASM INT &H16		;SEE P.222-THE IBM PC & PS/2
        ASM JZ KEYCLEAR2
        ASM MOV AH,0
        ASM INT &H16
        ASM JMP KEYCLEAR1
KEYCLEAR2:

'	ASM MOV AH,&H0C		;CLEAR KEYBOARD BUFFER
'        ASM INT &H21


RETURN


	' DISPLAY X,Y,Z,A POSITION SUB PROGRAMS '

SUB XDISPLAY
	SHARED X,XSTEPSIZE,UNIT$
	IF UNIT$="mm" THEN
   		LOCATE 3,10:PRINT USING"####.##";ROUND(X/XSTEPSIZE,2)
        ELSE
		LOCATE 3,11:PRINT USING"###.####";X/XSTEPSIZE
        END IF
END SUB

SUB YDISPLAY
	SHARED Y,YSTEPSIZE,UNIT$
	IF UNIT$="mm" THEN
   		LOCATE 4,10:PRINT USING"####.##";ROUND(Y/YSTEPSIZE,2)
        ELSE
		LOCATE 4,11:PRINT USING"###.####";Y/YSTEPSIZE
        END IF
END SUB

SUB ZDISPLAY
	SHARED Z,ZSTEPSIZE,UNIT$
	IF UNIT$="mm" THEN
   		LOCATE 5,10:PRINT USING"####.##";ROUND(Z/ZSTEPSIZE,2)
        ELSE
		LOCATE 5,11:PRINT USING"###.####";Z/ZSTEPSIZE
        END IF
END SUB

SUB ADISPLAY
	SHARED A,ASTEPSIZE,UNIT$
	IF UNIT$="mm" THEN
   		LOCATE 6,10:PRINT USING"####.##";ROUND(A/ASTEPSIZE,2)
        ELSE
		LOCATE 6,10:PRINT USING"####.####";A/ASTEPSIZE
        END IF
END SUB

SUB BDISPLAY
	SHARED B,BSTEPSIZE,UNIT$
	IF UNIT$="mm" THEN
   		LOCATE 7,10:PRINT USING"####.##";ROUND(B/BSTEPSIZE,2)
        ELSE
		LOCATE 7,10:PRINT USING"####.####";B/BSTEPSIZE
        END IF
END SUB


SUB CIRCULARINTCW
	SHARED X,Y,IINC,JINC,XINC%,YINC%
	SHARED XEND,YEND,XNEW,YNEW,XOLD,YOLD,SCALE
	SHARED SPEED,FEEDRATE,UNIT$

SPEED=FEEDRATE

MULTIPLELOOP%=0

OCTCW1%=0:OCTCW2%=0:OCTCW3%=0:OCTCW4%=0
OCTCW5%=0:OCTCW6%=0:OCTCW7%=0:OCTCW8%=0

XERROR=8:YERROR=8
XYERROR=1

IF ABS(XEND-X)<=XYERROR AND ABS(YEND-Y)<=XYERROR THEN FULLCIR%=1 ELSE FULLCIR%=0
XC = X+IINC : YC = Y+JINC
R =SQR(IINC*IINC+JINC*JINC)

IINC=0:JINC=0			'ZERO OUT I,J FOR FADAL FORMAT FILES
SQRR = R/SQR(2)

IF (X-XC)=>0 AND (Y-YC)>0 THEN 10
IF (X-XC)>0 AND (Y-YC)<=0 THEN 30
IF (X-XC)<=0 AND (Y-YC)<0 THEN 50
IF (X-XC)<0 AND (Y-YC)=>0 THEN 70

REM *** 90 DEG TO 45 DEG ***

DO

IF MULTIPLELOOP%=1 THEN 2000
MULTIPLELOOP%=1

FULLCIR%=0

10

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCW1% = 1 ELSE OCTCW1% = 0

IF X-XC=>SQRR THEN 20

P = 5/4 - R

WHILE (Y-YC) > X-XC
	IF P < 0 THEN
		P = P+2*(X-XC)+3
		X=X+1:XINC%=1:CALL STEPX
	ELSE
		P = P+2*(X-XC)-2*(Y-YC)+5
		X=X+1:Y=Y-1:XINC%=1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW1% = 0 THEN
	IF XEND-XC => 0 AND YEND-YC > 0 THEN	'CHECK IF END IS IN FIRST QUAD
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND AND Y<=YEND+YERROR THEN 2000
	END IF
END IF

WEND


REM ****** 45 DEG TO 0 DEG ******

20

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCW2% = 1 ELSE OCTCW2% = 0


P = 5/4 - R

WHILE (Y-YC) > 0

	IF P > 0 THEN
		P = P-2*(Y-YC)+3
		Y=Y-1:YINC%=-1:CALL STEPY
	ELSE
		P = P+2*(X-XC)-2*(Y-YC)+5
		X=X+1:Y=Y-1:XINC%=1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW2% = 0 THEN
	IF XEND-XC > 0 AND YEND-YC => 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND-XERROR AND Y<=YEND THEN 2000
	END IF
END IF

WEND


REM *** 0 TO -45 DEG ***

30

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCW3% = 1 ELSE OCTCW3% = 0

IF (X-XC) <= SQRR THEN 40

P = 5/4 - R

WHILE (X-XC) > -(Y-YC)

	IF P < 0 THEN
		P = P-2*(Y-YC)+3
		Y=Y-1:YINC%=-1:CALL STEPY
	ELSE
		P = P-2*(X-XC)-2*(Y-YC)+5
		X=X-1:Y=Y-1:XINC%=-1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW3% = 0 THEN
	IF XEND-XC > 0 AND YEND-YC <= 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND+XERROR AND Y<=YEND THEN 2000
	END IF
END IF

WEND


REM ***  -45 TO -90  ***

40

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCW4% = 1 ELSE OCTCW4% = 0


P = 5/4 - R

WHILE (X-XC) > 0

	IF P > 0 THEN
		P=P-2*(X-XC)+3
		X=X-1:XINC%=-1:CALL STEPX
	ELSE
		P=P-2*(X-XC)-2*(Y-YC)+5
		X=X-1:Y=Y-1:XINC%=-1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW4% = 0 THEN
	IF XEND-XC => 0 AND YEND-YC < 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND AND Y<=YEND+YERROR THEN 2000
	END IF
END IF

WEND


REM ***  -90 TO -135  ***

50

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCW5% = 1 ELSE OCTCW5% = 0

IF -(X-XC) => SQRR THEN 60

P = 5/4 - R

WHILE -(Y-YC) > -(X-XC)

	IF P < 0 THEN
		P=P-2*(X-XC)+3
		X=X-1:XINC%=-1:CALL STEPX
	ELSE
		P=P-2*(X-XC)+2*(Y-YC)+5
		X=X-1:Y=Y+1:XINC%=-1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW5% = 0 THEN
	IF XEND-XC <= 0 AND YEND-YC < 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND AND Y=>YEND-YERROR THEN 2000
	END IF
END IF

WEND


REM *** -135 TO -180 ***

60

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCW6% = 1 ELSE OCTCW6% = 0

P = 5/4 - R

WHILE (Y-YC) <= 0

	IF P > 0 THEN
		P=P+2*(Y-YC)+3
		Y=Y+1:YINC%=1:CALL STEPY
	ELSE
		P=P-2*(X-XC)+2*(Y-YC)+5
		X=X-1:Y=Y+1:XINC%=-1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW6% = 0 THEN
	IF XEND-XC < 0 AND YEND-YC <= 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND+XERROR AND Y=>YEND THEN 2000
	END IF
END IF

WEND


REM *** -180 TO -225 ***

70

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCW7% = 1 ELSE OCTCW7% = 0

IF -(X-XC) <= SQRR THEN 80

P = 5/4 - R

WHILE (Y-YC) < -(X-XC)

	IF P < 0 THEN
		P=P+2*(Y-YC)+3
		Y=Y+1:YINC%=1:CALL STEPY
	ELSE
		P=P+2*(X-XC)+2*(Y-YC)+5
		X=X+1:Y=Y+1:XINC%=1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW7% = 0 THEN
	IF XEND-XC < 0 AND YEND-YC => 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND-XERROR AND Y=>YEND THEN 2000
	END IF
END IF

WEND


REM *** -225 TO -270 ***

80

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCW8% = 1 ELSE OCTCW8% = 0


P = 5/4 - R

WHILE (X-XC) < 0

	IF P > 0 THEN
		P=P+2*(X-XC)+3
		X=X+1:XINC%=1:CALL STEPX
	ELSE
		P=P+2*(X-XC)+2*(Y-YC)+5
		X=X+1:Y=Y+1:XINC%=1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1000

IF OCTCW8% = 0 THEN
	IF XEND-XC <= 0 AND YEND-YC > 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
        	IF X=>XEND AND Y=>YEND-YERROR THEN 2000
	END IF
END IF

WEND


LOOP

1000

	GOSUB PLOTDISPLAY

RETURN

2000

XOLD=X:YOLD=Y
X=XEND:Y=YEND

COLOR 11
CALL XDISPLAY
CALL YDISPLAY

END SUB


SUB CIRCULARINTCCW
	SHARED X,Y,IINC,JINC,XINC%,YINC%,YINCOLD%
	SHARED XEND,YEND,XNEW,YNEW,XOLD,YOLD,SCALE
	SHARED SPEED,FEEDRATE,UNIT$,BACKLASHFLAG%

SPEED=FEEDRATE

MULTIPLELOOP%=0

OCTCCW1%=0:OCTCCW2%=0:OCTCCW3%=0:OCTCCW4%=0
OCTCCW5%=0:OCTCCW6%=0:OCTCCW7%=0:OCTCCW8%=0

XERROR=8:YERROR=8
XYERROR=1

IF ABS(XEND-X)<=XYERROR AND ABS(YEND-Y)<=XYERROR THEN FULLCIR%=1 ELSE FULLCIR%=0
XC = X+IINC : YC = Y+JINC
R = SQR(IINC*IINC+JINC*JINC)

IINC=0:JINC=0			'ZERO OUT I,J FOR FADEL FORMAT FILES
SQRR = R/SQR(2)

IF (X-XC)>0 AND (Y-YC)=>0 THEN 75
IF (X-XC)=>0 AND (Y-YC)<0 THEN 55
IF (X-XC)<0 AND (Y-YC)<=0 THEN 35
IF (X-XC)<=0 AND (Y-YC)>0 THEN 15


REM *** -270 TO -225 ***

DO


IF MULTIPLELOOP%=1 THEN 2010
MULTIPLELOOP%=1

FULLCIR%=0

15

'
'CHECK IF ARC MOVES CCW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCCW8% = 1 ELSE OCTCCW8% = 0


IF -(X-XC)=>SQRR THEN 25

P = 1 - R

WHILE (Y-YC) > -(X-XC)

	IF P < 0 THEN
		P=P-2*(X-XC)+3
		X=X-1:XINC%=-1:CALL STEPX
	ELSE
		P=P-2*(X-XC)-2*(Y-YC)+5
		X=X-1:Y=Y-1:XINC%=-1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW8% = 0 THEN
	IF XEND-XC <= 0 AND YEND-YC > 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND AND Y<=YEND+YERROR THEN 2010
	END IF
END IF

WEND

REM *** -225 TO -180 ***

25

'
'CHECK IF ARC MOVES CCW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCCW7% = 1 ELSE OCTCCW7% = 0


P = 1 - R

WHILE (Y-YC) > 0

	IF P > 0 THEN
		P=P-2*(Y-YC)+3
		Y=Y-1:YINC%=-1:CALL STEPY
	ELSE
		P=P-2*(X-XC)-2*(Y-YC)+5
		X=X-1:Y=Y-1:XINC%=-1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW7% = 0 THEN
	IF XEND-XC < 0 AND YEND-YC => 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND+XERROR AND Y<=YEND THEN 2010
	END IF
END IF

WEND

REM *** -180 TO -135 ***

35

'
'CHECK IF ARC MOVES CCW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCCW6% = 1 ELSE OCTCCW6% = 0

IF -(X-XC)<=SQRR THEN 45

P = 1 - R

WHILE -(X-XC) > -(Y-YC)

	IF P < 0 THEN
		P=P-2*(Y-YC)+3
		Y=Y-1:YINC%=-1:CALL STEPY
	ELSE
		P=P+2*(X-XC)-2*(Y-YC)+5
		X=X+1:Y=Y-1:XINC%=1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW6% = 0 THEN
	IF XEND-XC < 0 AND YEND-YC <= 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND-XERROR AND Y<=YEND THEN 2010
	END IF
END IF

WEND

REM ***  -135 TO -90  ***

45

'
'CHECK IF ARC MOVES CCW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND > Y
'

IF YEND > Y+XYERROR THEN OCTCCW5% = 1 ELSE OCTCCW5% = 0


P = 1 - R

WHILE -(X-XC) > 0

	IF P > 0 THEN
		P=P+2*(X-XC)+3
		X=X+1:XINC%=1:CALL STEPX
	ELSE
		P=P+2*(X-XC)-2*(Y-YC)+5
		X=X+1:Y=Y-1:XINC%=1:CALL STEPX
		YINC%=-1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW5% = 0 THEN
	IF XEND-XC <= 0 AND YEND-YC < 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND AND Y<=YEND+YERROR THEN 2010
	END IF
END IF

WEND


REM ***  -90 TO -45  ***

55

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCCW4% = 1 ELSE OCTCCW4% = 0


IF (X-XC)=>SQRR THEN 65

REM P = 1 + R
P = 1 - R


WHILE -(Y-YC) > (X-XC)

	IF P < 0 THEN
		P=P+2*(X-XC)+3
		X=X+1:XINC%=1:CALL STEPX
	ELSE
		P=P+2*(X-XC)+2*(Y-YC)+5
		X=X+1:Y=Y+1:XINC%=1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW4% = 0 THEN
	IF XEND-XC => 0 AND YEND-YC < 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND AND Y=>YEND-YERROR THEN 2010
	END IF
END IF

WEND

REM *** -45 TO 0 DEG ***

65

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCCW3% = 1 ELSE OCTCCW3% = 0


P = 1 - R

WHILE -(Y-YC) > 0

	IF P > 0 THEN
		P = P+2*(Y-YC)+3
		Y=Y+1:YINC%=1:CALL STEPY
	ELSE
		P = P+2*(X-XC)+2*(Y-YC)+5
		X=X+1:Y=Y+1:XINC%=1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW3% = 0 THEN
	IF XEND-XC > 0 AND YEND-YC <= 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X=>XEND-XERROR AND Y=>YEND THEN 2010
	END IF
END IF

WEND

REM ****** 0 DEG TO 45 DEG ******

75

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCCW2% = 1 ELSE OCTCCW2% = 0

IF (X-XC)<=SQRR THEN 85

P = 1 - R

WHILE (X-XC) > (Y-YC)

	IF P < 0 THEN
		P = P+2*(Y-YC)+3
		Y=Y+1:YINC%=1:CALL STEPY
	ELSE
		P = P-2*(X-XC)+2*(Y-YC)+5
		X=X-1:Y=Y+1:XINC%=-1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW2% = 0 THEN
	IF XEND-XC > 0 AND YEND-YC => 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND+XERROR AND Y=>YEND THEN 2010
	END IF
END IF

WEND

REM *** 45 DEG TO 90 DEG ***

85

'
'CHECK IF ARC MOVES CW ALL THE WAY BACK TO SAME QUADRANT
'IN THIS CASE YEND < Y
'

IF YEND+XYERROR < Y THEN OCTCCW1% = 1 ELSE OCTCCW1% = 0


P = 1 - R

WHILE (X-XC) > 0

	IF P > 0 THEN
		P = P-2*(X-XC)+3
		X=X-1:XINC%=-1:CALL STEPX
	ELSE
		P = P-2*(X-XC)+2*(Y-YC)+5
		X=X-1:Y=Y+1:XINC%=-1:CALL STEPX
		YINC%=1:CALL STEPY
	END IF

GOSUB 1010

IF OCTCCW1% = 0 THEN
	IF XEND-XC => 0 AND YEND-YC > 0 THEN
		IF FULLCIR%=1 THEN EXIT IF
		IF X<=XEND AND Y=>YEND-YERROR THEN 2010
	END IF
END IF

WEND


LOOP

1010

	GOSUB PLOTDISPLAY

RETURN

2010

XOLD=X:YOLD=Y
X=XEND:Y=YEND

COLOR 11
CALL XDISPLAY
CALL YDISPLAY

END SUB


	' X,Y,Z,A LINEAR MOVE SUB PROGRAM  '

XYZAMOVE:

REM IF CUTTERCOMP%=1 THEN CALL CUTTERCOMPG41

IF INCMODE% = 1 THEN            	'CHECK FOR G91 INCREMENTAL MODE'

	DX=ABS(XNEWINC)
	DY=ABS(YNEWINC)
	DZ=ABS(ZNEWINC)
	DA=ABS(ANEWINC)
        DB=ABS(BNEWINC)

        IF DX<1 THEN DX=0		'IF VALUE LESS THAN 1/8000 INCH
        IF DY<1 THEN DY=0		'SET IT TO ZERO
        IF DZ<1 THEN DZ=0
        IF DA<1 THEN DA=0
        IF DB<1 THEN DB=0

	IF DX<>0 THEN
        	IF XNEWINC >0 THEN XINC%=1 ELSE XINC%=-1
        END IF
        IF DY<>0 THEN
        	IF YNEWINC >0 THEN YINC%=1 ELSE YINC%=-1
        END IF
        IF DZ<>0 THEN
        	IF ZNEWINC >0 THEN ZINC%=1 ELSE ZINC%=-1
        END IF
        IF DA<>0 THEN
        	IF ANEWINC >0 THEN AINC%=1 ELSE AINC%=-1
	END IF
        IF DB<>0 THEN
        	IF BNEWINC >0 THEN BINC%=1 ELSE BINC%=-1
	END IF

ELSE                            	'ELSE CALCULATE G90 ABSOLUTE MODE'
	DX = ABS(XNEW - XOLD)
	DY = ABS(YNEW - YOLD)
	DZ = ABS(ZNEW - ZOLD)
	DA = ABS(ANEW - AOLD)
        DB = ABS(BNEW - BOLD)

        IF DX<1 THEN DX=0		'IF VALUE LESS THAN 1/8000 INCH
        IF DY<1 THEN DY=0		'SET IT TO ZERO
        IF DZ<1 THEN DZ=0
        IF DA<1 THEN DA=0
        IF DB<1 THEN DB=0

	IF DX<>0 THEN
		IF XNEW > XOLD THEN XINC% = 1 ELSE XINC% = -1
	END IF
	IF DY<>0 THEN
		IF YNEW > YOLD THEN YINC% = 1 ELSE YINC% = -1
	END IF
	IF DZ<>0 THEN
        	IF ZNEW > ZOLD THEN ZINC% = 1 ELSE ZINC% = -1
	END IF
	IF DA<>0 THEN
        	IF ANEW > AOLD THEN AINC% = 1 ELSE AINC% = -1
	END IF
	IF DB<>0 THEN
        	IF BNEW > BOLD THEN BINC% = 1 ELSE BINC% = -1
	END IF

END IF

IF PREVIEWFLAG% = -1 THEN		'SKIP IF IN PREVIEW MODE
	IF BACKLASHFLAG%=1 THEN
 		GOSUB XBACKLASH		'COMPENSATE FOR BACKLASH BEFORE
        	GOSUB YBACKLASH		'XYZA VECTOR MOVE IS EXECUTED
        	GOSUB ZBACKLASH
        	GOSUB ABACKLASH
	END IF
END IF


XYZAMOVECONTINUE:

REM ** CALCULATE THE PROJECTION RATIOS FOR LATER USE IN THE DELAY ROUTINES **

DRSQUARE = SQR(DX*DX+DY*DY+DZ*DZ+DA*DA+DB*DB)
IF DRSQUARE = 0 THEN DRSQUARE = 1

DXR=DX/DRSQUARE
DYR=DY/DRSQUARE
DZR=DZ/DRSQUARE
DAR=DA/DRSQUARE
DBR=DB/DRSQUARE

IF DX => DY AND DX => DZ AND DX => DA AND DX => DB THEN
	DXYZA=DX
	DU=DX
	SPEED=SPEED*DXR
        XSKIPDELAY%=0:YSKIPDELAY%=1:ZSKIPDELAY%=1
        ASKIPDELAY%=1:BSKIPDELAY%=1
ELSEIF DY => DX AND DY => DZ AND DY => DA AND DY => DB THEN
	DXYZA=DY
	DU=DY
        SPEED=SPEED*DYR
        XSKIPDELAY%=1:YSKIPDELAY%=0:ZSKIPDELAY%=1
        ASKIPDELAY%=1:BSKIPDELAY%=1
ELSEIF DZ => DX AND DZ => DY AND DZ => DA AND DZ => DB THEN
	DXYZA=DZ
	DU=DZ
        SPEED=SPEED*DZR
        XSKIPDELAY%=1:YSKIPDELAY%=1:ZSKIPDELAY%=0
        ASKIPDELAY%=1:BSKIPDELAY%=1
ELSEIF DA => DX AND DA => DY AND DA => DZ AND DA => DB THEN
	DXYZA=DA
	DU=DA
        SPEED=SPEED*DAR
        XSKIPDELAY%=1:YSKIPDELAY%=1:ZSKIPDELAY%=1
        ASKIPDELAY%=0:BSKIPDELAY%=1
ELSE
	DXYZA=DB
	DU=DB
        SPEED=SPEED*DBR
        XSKIPDELAY%=1:YSKIPDELAY%=1:ZSKIPDELAY%=1
        ASKIPDELAY%=1:BSKIPDELAY%=0
END IF

REM ** CALCULATE 5-D BRESENHAM VARIABLES **

TWODX = 2*DX : TWODY = 2*DY : TWODZ = 2*DZ
TWODA = 2*DA : TWODB = 2*DB
PX = TWODX - DU : PY = TWODY-DU : PZ = TWODZ-DU
PA = TWODA - DU : PB = TWODB-DU
TWODUDX = 2*(DX-DU) : TWODUDY = 2*(DY-DU)
TWODUDZ = 2*(DZ-DU) : TWODUDA = 2*(DA-DU)
TWODUDB = 2*(DB-DU)

X=XOLD:Y=YOLD:Z=ZOLD:A=AOLD:B=BOLD:U=0

WHILE U < DU
	DELXYZA&=U
	U = U + 1
	IF PX < 0 THEN
	PX = PX + TWODX
	ELSE
	X = X + XINC% : PX = PX + TWODUDX
	CALL STEPX
	END IF
	IF PY < 0 THEN
	PY = PY + TWODY
	ELSE
	Y = Y + YINC% : PY = PY + TWODUDY
	CALL STEPY
	END IF
	IF PZ < 0 THEN
	PZ = PZ + TWODZ
	ELSE
	Z = Z + ZINC% : PZ = PZ + TWODUDZ
	CALL STEPZ
	END IF
	IF PA < 0 THEN
	PA = PA + TWODA
	ELSE
	A = A + AINC% : PA = PA + TWODUDA
	CALL STEPA
	END IF
	IF PB < 0 THEN
	PB = PB + TWODB
	ELSE
	B = B + BINC% : PB = PB + TWODUDB
	CALL STEPB
	END IF

        GOSUB PLOTDISPLAY

WEND

	COLOR 11

	CALL XDISPLAY
	CALL YDISPLAY
	CALL ZDISPLAY
	CALL ADISPLAY
        CALL BDISPLAY

 	XOLD=X:YOLD=Y:ZOLD=Z:AOLD=A:BOLD=B
        XNEW=X:YNEW=Y:ZNEW=Z:ANEW=A:BNEW=B
	XNEWINC=0:YNEWINC=0:ZNEWINC=0:ANEWINC=0:BNEWINC=0

RETURN

		'OLD = NEW IN ROUTINE ABOVE INSTEAD OF XOLD = X, ETC.
		'TO MAINTAIN PRECISE VALUE THAT IS NECESSARY IN
                'CIRCULAR INTERPOLATION ROUTINES
                'NOTE: REVISED TO XOLD=X, ETC. SO ROUNDOFF ERROR IS
                'ELIMINATED (14 JAN 2002). NEW CIR ROUTINES NOT AFFECTED

REM *** G81 AND G83 DRILL CYCLE OPERATION ***

SUB DRILLCYCLE
SHARED ZNEW,ZOLD,ZDEPTH,RPLANE,QPECKINC,PECKDRILL%,FEEDRATE,RAPID,SPEED
SHARED IPLANERETURN%,SPEEDINC,ACCELRAMP%,ARAMP%,ACCELINC

	ACCELRAMP% = ARAMP%
	SPEEDTEMP = SPEEDINC	'STORE FEEDRATE CALCULATED SPEEDINC
	ZNEW=ZOLD               'STAY AT SAME Z HEIGHT'
	IPLANE=ZNEW             'SET IPLANE TO CURRENT Z HEIGHT'
        SPEEDINC=ACCELINC
        SPEED=RAPID

	IF IPLANERETURN%=1 THEN PLANE=IPLANE ELSE PLANE=RPLANE
	GOSUB XYZAMOVE          'MOVE TO NEW X,Y,A POSITION'
	ZNEW=RPLANE             'RAPID Z TO RPLANE'
	SPEEDINC=ACCELINC
        SPEED=RAPID
	GOSUB XYZAMOVE
	ZTEMP=RPLANE
	RPLANETEMP=RPLANE       'SET TEMP VALUE TO FEED FROM FIRST'
				'PASS FROM RPLANE TO 1ST PECK DISTANCE'
	IF PECKDRILL%=1 THEN
		WHILE ZTEMP > ZDEPTH
			ZNEW=ZTEMP
			ZNEW=ZNEW+0.025 'RAPID DOWN TO 0.025" ABOVE NEXT'
                        SPEEDINC=ACCELINC
			SPEED=RAPID   'PECK STARTING DEPTH'
				GOSUB XYZAMOVE

			ZNEWTEMP=ZNEW-QPECKINC-.025-RPLANETEMP

                        IF ZNEWTEMP < ZDEPTH THEN
                        	ZNEW = ZDEPTH
                        ELSE
                        	ZNEW = ZNEWTEMP
                        END IF

                        SPEEDINC=SPEEDTEMP
			SPEED=FEEDRATE
				GOSUB XYZAMOVE  'PECK TO Z DEPTH'
			RPLANETEMP=0
			ZTEMP=ZNEW
			ZNEW=PLANE              'RAPID BACK TO PLANE'
			SPEED=RAPID
                        SPEEDINC=ACCELINC
				GOSUB XYZAMOVE
		WEND
	ELSE
		SPEED=FEEDRATE
                SPEEDINC=SPEEDTEMP
		ZNEW=ZDEPTH             'FEED Z TO DRILL DEPTH'
		GOSUB XYZAMOVE
	END IF

	ZNEW=PLANE              'RAPID BACK TO RPLANE'
	SPEED=RAPID
        SPEEDINC=ACCELINC
	GOSUB XYZAMOVE

END SUB


REM *** G41 LEFT HAND SIDE CUTTER COMPENSATION ***

SUB CUTTERCOMPG41
SHARED XNEW,YNEW,XOLD,YOLD,XNEW2,YNEW2,CUTTERRADIUS

IF XNEW = XOLD THEN
	XNEW = XNEW
ELSEIF XNEW < XOLD AND YNEW > YOLD THEN
	XNEW = XNEW-CUTTERRADIUS
ELSEIF XNEW < XOLD AND YNEW < YOLD THEN
	XNEW = XNEW+CUTTERRADIUS
ELSEIF XNEW > XOLD AND YNEW > YOLD THEN
	XNEW = XNEW-CUTTERRADIUS
ELSEIF XNEW > XOLD AND YNEW < YOLD THEN
	XNEW = XNEW+CUTTERRADIUS
END IF

IF YNEW = YOLD THEN
	YNEW = YNEW
ELSEIF YNEW < YOLD AND XNEW <= XOLD THEN
	YNEW = YNEW-CUTTERRADIUS
ELSEIF YNEW < YOLD AND XNEW > XOLD THEN
	YNEW = YNEW+CUTTERRADIUS
ELSEIF YNEW > YOLD THEN
	YNEW = YNEW+CUTTERRADIUS
END IF


END SUB


	'  X STEP MOTOR MOVE  '

SUB STEPX

	SHARED XINC%,XPORT%,XYSEQUENCE%,XSEQ%,XAXIS%(),SPEED
        SHARED PREVIEWFLAG%,BACKLASHFLAG%

        IF PREVIEWFLAG%=1 THEN XPREVIEW
	IF BACKLASHFLAG%=1 THEN GOSUB XBACKLASH

        GOSUB STEPXINC

XPREVIEW:
	GOSUB CHECKSLIDEHOLD

END SUB

	'  Y STEP MOTOR MOVE  '

SUB STEPY

	SHARED YINC%,YPORT%,XYSEQUENCE%,YSEQ%,YAXIS%(),SPEED
        SHARED PREVIEWFLAG%,BACKLASHFLAG%,GCODEMOVE

        IF PREVIEWFLAG%=1 THEN YPREVIEW
	IF BACKLASHFLAG%=1 THEN GOSUB YBACKLASH

        GOSUB STEPYINC

YPREVIEW:
	GOSUB CHECKSLIDEHOLD

END SUB

	'  Z STEP MOTOR MOVE  '

SUB STEPZ

	SHARED ZINC%,ZPORT%,ZSEQ%,ZAXIS%(),SPEED
        SHARED PREVIEWFLAG%,BACKLASHFLAG%

        IF PREVIEWFLAG%=1 THEN ZPREVIEW
	IF BACKLASHFLAG%=1 THEN GOSUB ZBACKLASH

        GOSUB STEPZINC

ZPREVIEW:
	GOSUB CHECKSLIDEHOLD

END SUB

	'  A STEP MOTOR MOVE  '

SUB STEPA

	SHARED AINC%,APORT%,ASEQ%,AAXIS%(),SPEED
        SHARED PREVIEWFLAG%,BACKLASHFLAG%

        IF PREVIEWFLAG%=1 THEN APREVIEW
	IF BACKLASHFLAG%=1 THEN GOSUB ABACKLASH

        GOSUB STEPAINC

APREVIEW:
	GOSUB CHECKSLIDEHOLD

END SUB

	'  B STEP MOTOR MOVE  '

SUB STEPB

	SHARED BINC%,BPORT%,BSEQ%,BAXIS%(),SPEED
        SHARED PREVIEWFLAG%,BACKLASHFLAG%

        IF PREVIEWFLAG%=1 THEN BPREVIEW
	IF BACKLASHFLAG%=1 THEN GOSUB BBACKLASH

        GOSUB STEPBINC

BPREVIEW:
	GOSUB CHECKSLIDEHOLD

END SUB

XYZADELAY:

DELAYINC& = DELAYINC&+1
IF DELAYINC& < ACCELRAMP% THEN SPEED = SPEED + SPEEDINC
IF DELAYINC& > DXYZA-ACCELRAMP% THEN SPEED = SPEED - SPEEDINC
IF DELAYINC& => DXYZA THEN DELAYINC& = 0

COUNT=1193280/SPEED
LO.COUNT=COUNT MOD 256
HI.COUNT=INT(COUNT/256)
OUT &H43,&HB6
OUT &H42,LO.COUNT
OUT &H42,HI.COUNT

OLD.PORT=INP(&H61)
NEW.PORT=(OLD.PORT OR &H01)
OUT &H61,NEW.PORT

XYZALOOPDELAY:
	ASM IN AL,&H61
        ASM AND AL,32		;CHECK I/O STATUS INPUT FOR 0
        ASM JNZ XYZALOOPDELAY
RETURN


XBACKLASH:
	IF XINCOLD%=XINC% THEN
        	RETURN
        ELSE
		XINCOLD%=XINC%
                SPEEDTEMP=SPEED:SPEEDINCTEMP=SPEEDINC
                DELAYINCTEMP&=DELAYINC&
        	XSKIPDELAYTEMP% = XSKIPDELAY%
                XSKIPDELAY%=0
                SPEED=MEDIUM:SPEEDINC=0:DELAYINC&=0

                FOR XBLINC = 1 TO XBACKVALUE
                	GOSUB STEPXINC
                NEXT

                SPEED=SPEEDTEMP:SPEEDINC=SPEEDINCTEMP
                DELAYINC&=DELAYINCTEMP&
		XSKIPDELAY%=XSKIPDELAYTEMP%
        END IF
RETURN

YBACKLASH:
	IF YINCOLD%=YINC% THEN
        	RETURN
        ELSE
		YINCOLD%=YINC%
                SPEEDTEMP=SPEED:SPEEDINCTEMP=SPEEDINC
                DELAYINCTEMP&=DELAYINC&
                YSKIPDELAYTEMP%=YSKIPDELAY%
                YSKIPDELAY%=0
                SPEED=MEDIUM:SPEEDINC=0:DELAYINC&=0

                FOR YBLINC = 1 TO YBACKVALUE
                	GOSUB STEPYINC
                NEXT

                SPEED=SPEEDTEMP:SPEEDINC=SPEEDINCTEMP
                DELAYINC&=DELAYINCTEMP&
                YSKIPDELAY%=YSKIPDELAYTEMP%
        END IF
RETURN

ZBACKLASH:
	IF ZINCOLD%=ZINC% THEN
        	RETURN
        ELSE
		ZINCOLD%=ZINC%
                SPEEDTEMP=SPEED:SPEEDINCTEMP=SPEEDINC
                DELAYINCTEMP&=DELAYINC&
                ZSKIPDELAYTEMP%=ZSKIPDELAY%
                ZSKIPDELAY%=0
                SPEED=MEDIUM:SPEEDINC=0:DELAYINC&=0

                FOR ZBLINC = 1 TO ZBACKVALUE
                	GOSUB STEPZINC
                NEXT

                SPEED=SPEEDTEMP:SPEEDINC=SPEEDINCTEMP
                DELAYINC&=DELAYINCTEMP&
		ZSKIPDELAY%=ZSKIPDELAYTEMP%
        END IF
RETURN

ABACKLASH:
	IF AINCOLD%=AINC% THEN
        	RETURN
        ELSE
		AINCOLD%=AINC%
                SPEEDTEMP=SPEED:SPEEDINCTEMP=SPEEDINC
                DELAYINCTEMP&=DELAYINC&
                ASKIPDELAYTEMP%=ASKIPDELAY%
                ASKIPDELAY%=0
                SPEED=MEDIUM:SPEEDINC=0:DELAYINC&=0

                FOR ABLINC = 1 TO ABACKVALUE
                	GOSUB STEPAINC
                NEXT

                SPEED=SPEEDTEMP:SPEEDINC=SPEEDINCTEMP
                DELAYINC&=DELAYINCTEMP&
                ASKIPDELAY%=ASKIPDELAYTEMP%
        END IF
RETURN

BBACKLASH:
	IF BINCOLD%=BINC% THEN
        	RETURN
        ELSE
		BINCOLD%=BINC%
                SPEEDTEMP=SPEED:SPEEDINCTEMP=SPEEDINC
                DELAYINCTEMP&=DELAYINC&
                BSKIPDELAYTEMP%=BSKIPDELAY%
                BSKIPDELAY%=0
                SPEED=MEDIUM:SPEEDINC=0:DELAYINC&=0

                FOR BBLINC = 1 TO BBACKVALUE
                	GOSUB STEPBINC
                NEXT

                SPEED=SPEEDTEMP:SPEEDINC=SPEEDINCTEMP
                DELAYINC&=DELAYINCTEMP&
                BSKIPDELAY%=BSKIPDELAYTEMP%
        END IF
RETURN


STEPXINC:
	IF XINC% = 1 THEN
		XSEQ% = XSEQ% + 1
		IF XSEQ% = 9 THEN XSEQ% = 1
	ELSE
		XSEQ% = XSEQ% - 1
		IF XSEQ% = 0 THEN XSEQ% = 8
	END IF
	XYSEQUENCE% = XYSEQUENCE% AND 240
	XYSEQUENCE% = XYSEQUENCE% OR XAXIS%(XSEQ%)
	OUT XPORT%, XYSEQUENCE%
        IF XSKIPDELAY%=0 THEN GOSUB XYZADELAY
RETURN

STEPYINC:
	IF YINC% = 1 THEN
		YSEQ% = YSEQ% + 1
		IF YSEQ% = 9 THEN YSEQ% = 1
	ELSE
		YSEQ% = YSEQ% - 1
		IF YSEQ% = 0 THEN YSEQ% = 8
	END IF
	XYSEQUENCE% = XYSEQUENCE% AND 15
	XYSEQUENCE% = XYSEQUENCE% OR YAXIS%(YSEQ%)
	OUT YPORT%, XYSEQUENCE%
	IF YSKIPDELAY%=0 THEN GOSUB XYZADELAY
RETURN

STEPZINC:
	IF ZINC% = 1 THEN
		ZSEQ% = ZSEQ% + 1
		IF ZSEQ% = 9 THEN ZSEQ% = 1
	ELSE
		ZSEQ% = ZSEQ% - 1
		IF ZSEQ% = 0 THEN ZSEQ% = 8
	END IF
	OUT ZPORT%, ZAXIS%(ZSEQ%)
	IF ZSKIPDELAY%=0 THEN GOSUB XYZADELAY
RETURN

STEPAINC:
	IF AINC% = 1 THEN
		ASEQ% = ASEQ% + 1
		IF ASEQ% = 9 THEN ASEQ% = 1
	ELSE
		ASEQ% = ASEQ% - 1
		IF ASEQ% = 0 THEN ASEQ% = 8
	END IF
	ABSEQUENCE% = ABSEQUENCE% AND 240
	ABSEQUENCE% = ABSEQUENCE% OR AAXIS%(ASEQ%)
	OUT APORT%, ABSEQUENCE%
        IF ASKIPDELAY%=0 THEN GOSUB XYZADELAY
RETURN

STEPBINC:
	IF BINC% = 1 THEN
		BSEQ% = BSEQ% + 1
		IF BSEQ% = 9 THEN BSEQ% = 1
	ELSE
		BSEQ% = BSEQ% - 1
		IF BSEQ% = 0 THEN BSEQ% = 8
	END IF
	ABSEQUENCE% = ABSEQUENCE% AND 15
	ABSEQUENCE% = ABSEQUENCE% OR BAXIS%(BSEQ%)
	OUT APORT%, ABSEQUENCE%
        IF BSKIPDELAY%=0 THEN GOSUB XYZADELAY
RETURN


PLOTDISPLAY:

IF ZCOLOR% < 0 THEN PLOTCOLOR = 3 ELSE PLOTCOLOR = 12

	IF PLOTVIEW% = 1 THEN
		XP = X + XOFFSET + 0.000*(Z-ZSAFE1)/ZSCALE
                YP = Y + YOFFSET + 0.000*(Z-ZSAFE1)/ZSCALE
        ELSE
		XP = X + XOFFSET + 0.707*(Z-ZSAFE1)/ZSCALE
		YP = Y + YOFFSET + 0.707*(Z-ZSAFE1)/ZSCALE
	END IF

	IF XP > 13200*PLOTSCALE OR XP < -13200*PLOTSCALE THEN NOPLOTX
	IF YP > 9900*PLOTSCALE OR YP < -9900*PLOTSCALE THEN NOPLOTY


	IF Z-ZSAFE1 <= 0 THEN
        	PSET(XP,YP),PLOTCOLOR
        ELSE
        	PSET(XDUMMY,YDUMMY),PLOTZERO	'DELAY COMPENSATION FOR
        END IF					'NO PLOTTING WHEN Z > 0

        RETURN

'
'INSERT DELAY COMPENSATION FOR MOVEMENT OUTSIDE WINDOW
'HENCE, THE SAME IF-THEN STATEMENTS ARE READ SO THE DELAY
'WILL BE INDEPENDENT OF THE COMPUTER SPEED
'
NOPLOTX:
	IF YP > 9900*PLOTSCALE OR YP < -9900*PLOTSCALE THEN
        END IF
        IF Z-ZSAFE1 <= 0 THEN PSET(XDUMMY,YDUMMY),PLOTZERO
	RETURN
NOPLOTY:
	IF XP > 13200*PLOTSCALE OR XP < -13200*PLOTSCALE THEN
        END IF
        IF Z-ZSAFE1 <= 0 THEN PSET(XDUMMY,YDUMMY),PLOTZERO
	RETURN

DISPLAYWINDOW:

	COLOR 15
	X1=20000*PLOTSCALE*1.33:Y1=20000*PLOTSCALE
	X2=10000*PLOTSCALE*1.33:Y2=10000*PLOTSCALE
        MARKER=500*PLOTSCALE
        X3 = X2

	WINDOW (-X1,-Y1) - (X2,Y2)
	LINE (-X3,-Y2) - (X3,-Y2)
	LINE (X3,-Y2) - (X3,Y2)
	LINE (X3,Y2) - (-X3,Y2)
	LINE (-X3,Y2) - (-X3,-Y2)

        LINE (0,-Y2)-(0,-Y2+MARKER)
        LINE (-X3,0)-(-X3+MARKER,0)

REM	COLOR 7
REM        FOR GRID = 1000 TO X3 STEP 1000
REM        	LINE(-X3+GRID,-Y2)-(-X3+GRID,Y2)
REM        NEXT

        COLOR 10
        LOCATE 21,27:PRINT USING"####.##";-(X2+XOFFSET)/XSTEPSIZE
        LOCATE 21,50:PRINT USING"####.##";-XOFFSET/XSTEPSIZE
	LOCATE 21,73:PRINT USING"####.##";(X2-XOFFSET)/XSTEPSIZE
        LOCATE 1,20:PRINT USING"####.##";(Y2-YOFFSET)/YSTEPSIZE
        LOCATE 11,20:PRINT USING"####.##";-YOFFSET/YSTEPSIZE
        LOCATE 20,20:PRINT USING"####.##";-(Y2+YOFFSET)/YSTEPSIZE

RETURN

MENU1:

COLOR 15
LOCATE 22,34:PRINT"MANUAL JOG.....1"
LOCATE 23,34:PRINT"LOAD PROGRAM...2"
LOCATE 24,34:PRINT"RUN PROGRAM....3"
LOCATE 25,34:PRINT"ZERO AXIS......4"
LOCATE 26,34:PRINT"SET SCALE......5"
LOCATE 27,34:PRINT"SET DEPTH INC..6"
LOCATE 28,34:PRINT"RESET PROGRAM..R"
LOCATE 22,58:PRINT"CONTINUE........C"
LOCATE 23,58:PRINT"JOG INCREMENT...J"
LOCATE 24,58:PRINT"BACKLASH COMP...K"
LOCATE 25,58:PRINT"FEED CHANGE.....F"
LOCATE 26,58:PRINT"CHANGE UNITS....U"
LOCATE 27,58:PRINT"DISPLAY TOOLS...T"
LOCATE 28,58:PRINT"SWITCH MENU.....M"

RETURN

MENU2:

COLOR 15
LOCATE 22,34:PRINT"PLOT PREVIEW...P"
LOCATE 23,34:PRINT"PLOT VIEW......V"
LOCATE 24,34:PRINT"PLOT SCALE.....L"
LOCATE 25,34:PRINT"REPEAT NUMBER..N"
LOCATE 26,34:PRINT"XY OFFSET......O"
LOCATE 27,34:PRINT"CLEAR DISPLAY..7"
LOCATE 28,34:PRINT"MDI MODE.......8"
LOCATE 22,58:PRINT"FILE DIRECTORY..9"
LOCATE 23,58:PRINT"RAPID/ACCEL.....A"
LOCATE 24,58:PRINT"SEL/DESEL.......";SEL$
LOCATE 25,58:PRINT"SAFE Z HEIGHT...Z"
LOCATE 26,58:PRINT"PORT BASE.......B"
LOCATE 27,58:PRINT"QUIT PROGRAM....Q"
LOCATE 28,58:PRINT"SWITCH MENU.....M"

RETURN

CLEARMENU:

FOR MENUCLEAR = 0 TO 7
LOCATE 22+MENUCLEAR,34:PRINT"                                           "
NEXT

RETURN

MANUALTOOLCHANGE:
	COLOR 14
	LOCATE 21,6:PRINT"TOOL CHANGE   "
	GOSUB SLIDEHOLDON
	MCODE = -1
RETURN

PROGRAMSTOP:
	COLOR 14
	LOCATE 21,6:PRINT"PROGRAM STOP   "
        GOSUB SLIDEHOLDON
        MCODE = -1
RETURN

CHECKSLIDEHOLD:
	IF MANUALFLAG%=1 THEN RETURN	'IF JOGGING DISABLE SPACEBAR
	ASM IN AL,&H60
	ASM CMP AL,57                   ;CHECK FOR SPACEBAR
	ASM JZ SLIDEHOLDON
        RETURN

SLIDEHOLDON:
	SLIDEHOLD%=1

        COLOR 11
	CALL XDISPLAY:CALL YDISPLAY:CALL ZDISPLAY
        CALL ADISPLAY:CALL BDISPLAY
	COLOR 14
        IF MCODE <> 6 AND MCODE <> 0 THEN
        	LOCATE 21,6:PRINT"SLIDE HOLD     "
        END IF

SINGLESTEPLINE:

	IF SPEED > 667 THEN SPEED = 600
	DXYZA = DXYZA-DELAYINC&		'SET DXYZA SO IT CAN ACCELERATE
        DELAYINC&=0			'BACK UP TO SPEED WITHOUT STALLING

STARTPROGRAM:

        LOCATE 23,1:PRINT"C=CONTINUOUS, S=SINGLE STEP"
        LOCATE 24,1:PRINT"F=FEED CHANGE, M=MAIN MENU"

GOSUB KEYCLEAR1		'CLEAR KEYBOARD BUFFER

DO
	Z$=INKEY$
	IF Z$="C" THEN
        	SINGLESTEP%=0
        	SLIDEHOLD%=0
REM                LOCATE 23,1:PRINT"SPACEBAR = SLIDEHOLD       "
                LOCATE 23,1:PRINT"                           "
                LOCATE 24,1:PRINT"                           "
                COLOR 11
        		IF DRYRUNFLAG% = -1 AND PREVIEWFLAG% = -1 THEN
                        	LOCATE 21,6:PRINT"RUN MODE       "
        		ELSEIF PREVIEWFLAG% = 1 THEN
        			LOCATE 21,6:PRINT"PLOT PREVIEW   "
        		ELSEIF DRYRUNFLAG% = 1 THEN
                        	LOCATE 21,6:PRINT"DRY RUN        "
        		END IF
                RETURN
        ELSEIF Z$="F" THEN
		LOCATE 23,1:PRINT"                           "
                LOCATE 24,1:PRINT"                           "
        	GOSUB FEEDCHANGE
                COLOR 14
        	LOCATE 23,1:PRINT"C=CONTINUOUS, S=SINGLE STEP"
                LOCATE 24,1:PRINT"F=FEED CHANGE, M=MAIN MENU"
        ELSEIF Z$="M" THEN
        	SLIDEHOLD%=1
		LOCATE 23,1:PRINT"                            "
                LOCATE 24,1:PRINT"                            "
                MENUFLAG%=1
		LOCATE 27,30:PRINT"     "		'CLEAR SPACE FOR MENU1
		LOCATE 28,30:PRINT"     "
		GOSUB MENU1
        	GOSUB MAIN1
                SLIDEHOLD%=0
                RETURN
        ELSEIF Z$="S" THEN
        	SINGLESTEP%=1
		LOCATE 23,1:PRINT"                            "
                LOCATE 24,1:PRINT"                            "
                LOCATE 21,6:PRINT"SINGLE STEP    "
                RETURN
        END IF
LOOP


'SAVE X,Y,Z,A COORDINATES, PORT ADDRESSES AND TOOL OFFSETS

EXITPROGRAM:
CLOSE # 1
OPEN "PARAM5.DAT" FOR OUTPUT AS #1

PRINT #1,X
PRINT #1,Y
PRINT #1,Z
PRINT #1,A
PRINT #1,B

PRINT #1,XPORT%
PRINT #1,ZPORT%
PRINT #1,APORT%

PRINT #1,RAPID
PRINT #1,ARAMP%
PRINT #1,ACCELINC

PRINT #1,BACKLASHFLAG%

PRINT #1,XBACKVALUE
PRINT #1,YBACKVALUE
PRINT #1,ZBACKVALUE
PRINT #1,ABACKVALUE
PRINT #1,BBACKVALUE

PRINT #1,UNIT$

PRINT #1,XSTEPSIZE
PRINT #1,YSTEPSIZE
PRINT #1,ZSTEPSIZE
PRINT #1,ASTEPSIZE
PRINT #1,BSTEPSIZE

PRINT #1,EXTEN$
PRINT #1,DIRNAME$

FOR OFFNUM = 1 TO 10
	PRINT #1,HOFFSET(OFFNUM)
NEXT

CLOSE #1

END
