/* 
    ELSCfg.h -- E-Leadscrew definitions for an electronic replacement of
    gears used for threading or hobbing on a Lathe or Gear Hobber.

    Copyright (C) 2005  John Dammeyer

    This file is part of The Electronic Lead Screw (ELS) Project.

    ELS is free software: you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Or download here.
	http://www.gnu.org/copyleft/gpl.html

    John Dammeyer
    johnd@autoartisans.com


   	Initial Version: 0.00a

   	Version changes: 
	1.10a
		Changed EEROM table to be latest image from ER command.
			Defaults for Z MOVE and SLEW rages lowered.
			Initial Taper Value set.
			Motor Timeout set to 5 seconds.
			Should solve an initial dvide by zero from parameters.

*/


#pragma romdata EEDATA
const rom unsigned char eememory[] = {
	0x0C,0x01,0x00,0x00,	 //   0(0x00)
	0x00,0x00,0x15,0x00,	 //   4(0x04)
	0xFF,0xFF,0xFF,0xFF,	 //   8(0x08)
	0xFF,0xFF,0xFF,0xFF,	 //  12(0x0C)
	0xFF,0xFF,0xFF,0xFF,	 //  16(0x10)
	0xFF,0xFF,0xFF,0xFF,	 //  20(0x14)
	0xFF,0xFF,0xFF,0xFF,	 //  24(0x18)
	0xFF,0xFF,0xFF,0xFF,	 //  28(0x1C)
	0xFF,0xFF,0xFF,0xFF,	 //  32(0x20)
	0xFF,0xFF,0xFF,0xFF,	 //  36(0x24)
	0xFF,0xFF,0xFF,0xFF,	 //  40(0x28)
	0xFF,0xFF,0xFF,0xFF,	 //  44(0x2C)
	0x00,0x00,0x00,0x00,	 //  48(0x30)
	0xCD,0xCC,0xCC,0x3D,	 //  52(0x34)
	0xB8,0x0B,0x00,0x00,	 //  56(0x38)
	0x02,0x00,0x00,0x00,	 //  60(0x3C)
	0x01,0x00,0x00,0x00,	 //  64(0x40)
	0x01,0x00,0x00,0x00,	 //  68(0x44)
	0x0A,0xD7,0xA3,0x3B,	 //  72(0x48)
	0x00,0x00,0xC8,0x44,	 //  76(0x4C)
	0x00,0x00,0x00,0x00,	 //  80(0x50)
	0x28,0x23,0x00,0x00,	 //  84(0x54)
	0x10,0x27,0x00,0x00,	 //  88(0x58)
	0xB8,0x0B,0x00,0x00,	 //  92(0x5C)
	0x6F,0x12,0x83,0x3A,	 //  96(0x60)
	0x00,0x00,0x00,0x00,	 // 100(0x64)
	0x00,0x00,0x00,0x00,	 // 104(0x68)
	0x00,0x00,0x00,0x00,	 // 108(0x6C)
	0x00,0x00,0x00,0x00,	 // 112(0x70)
	0x05,0x00,0x00,0x00,	 // 116(0x74)
	0xCD,0xCC,0x4C,0x3D,	 // 120(0x78)
	0xE8,0x03,0x00,0x00,	 // 124(0x7C)
	0xB8,0x0B,0x00,0x00,	 // 128(0x80)
	0x60,0x09,0x00,0x00,	 // 132(0x84)
	0x6F,0x12,0x83,0x3A,	 // 136(0x88)
	0x00,0x00,0x00,0x00,	 // 140(0x8C)
	0x00,0x00,0x00,0x00,	 // 144(0x90)
	0x5F,0x98,0x4C,0x3D,	 // 148(0x94)
	0xCD,0xCC,0x4C,0x3D,	 // 152(0x98)
	0x00,0x00,0xEC,0x41,	 // 156(0x9C)
	0xCD,0xCC,0xCC,0x3D,	 // 160(0xA0)
	0x00,0x00,0x00,0x00,	 // 164(0xA4)
	0x0A,0xD7,0xA3,0x3B,	 // 168(0xA8)
	0x6F,0x12,0x03,0x3B,	 // 172(0xAC)
	0x6F,0x12,0x83,0x3A,	 // 176(0xB0)
	0x03,0x00,0x00,0x00,	 // 180(0xB4)
	0x6B,0xB7,0xDD,0x3C,	 // 184(0xB8)
	0x00,0x00,0x00,0x00,	 // 188(0xBC)
	0x00,0x00,0x00,0x00,	 // 192(0xC0)
	0x00,0x00,0x00,0x00,	 // 196(0xC4)
	0x00,0x00,0x00,0x00,	 // 200(0xC8)
	0x00,0x00,0x00,0x00,	 // 204(0xCC)
	0xA3,0x92,0x0A,0x3F,	 // 208(0xD0)
	0xFF,0xFF,0xFF,0xFF,	 // 212(0xD4)
	0xFF,0xFF,0xFF,0xFF,	 // 216(0xD8)
	0xFF,0xFF,0xFF,0xFF,	 // 220(0xDC)
	0xFF,0xFF,0xFF,0xFF,	 // 224(0xE0)
	0xFF,0xFF,0xFF,0xFF,	 // 228(0xE4)
	0xFF,0xFF,0xFF,0xFF,	 // 232(0xE8)
	0xFF,0xFF,0xFF,0xFF,	 // 236(0xEC)
	0xFF,0xFF,0xFF,0xFF,	 // 240(0xF0)
	0xFF,0xFF,0xFF,0xFF,	 // 244(0xF4)
	0xFF,0xFF,0xFF,0xFF,	 // 248(0xF8)
	0xFF,0xFF,0xFF,0xFF,	 // 252(0xFC)
	0x01,0x02,0x03,0x04,	 // 256(0x100)
};
#pragma romdata




#pragma romdata IDLOCS
const rom unsigned char idlocs_memory[] = {
	0xAA,0x01,0x02,0x03,0x04,0x05,0x06,0x55
};

#pragma romdata CONFIG

// defined in processor.h
#pragma config OSC = HSPLL
#pragma config PWRT = OFF
#pragma config WDT = OFF
//#pragma config BOREN = BOHW
#pragma config BORV = 3
#pragma config PBADEN = OFF
//#pragma config WDTPS = 32768 
//#pragma config STVR = ON
#pragma config LVP = OFF

#pragma romdata

